/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.ovomorph;

import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.util.AVPPredicates;
import com.lib.common.gameplay.entity.manager.VibrationSystemManager;
import com.lib.common.network.DataAccessor;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;

public class HatchDesireManager {
    private static final int MAXIMUM_DESIRE_TO_HATCH = 100;
    private final Ovomorph ovomorph;
    private final DataAccessor<Integer> desireToHatch;
    private VibrationInfo lastVibrationInfo;

    public HatchDesireManager(Ovomorph ovomorph) {
        this.ovomorph = ovomorph;
        this.desireToHatch = new DataAccessor<Integer>(ovomorph, AVPDataKeys.OVOMORPH_DESIRE_TO_HATCH);
    }

    public void tick() {
        this.handleVibration();
        if (this.ovomorph.tickCount % 20 == 0) {
            this.addDesire(-1);
        }
        if (this.ovomorph.getHatchManager().isHatched()) {
            this.desireToHatch.reset();
        }
    }

    private void handleVibration() {
        VibrationSystemManager vibrationSystemManager = this.ovomorph.getVibrationSystemManager();
        VibrationInfo vibrationInfo = vibrationSystemManager.getVibrationData().getCurrentVibration();
        if (vibrationInfo != null && !Objects.equals(vibrationInfo, this.lastVibrationInfo)) {
            int radius = vibrationSystemManager.getVibrationUser().getListenerRadius();
            Entity sourceEntity = vibrationInfo.entity();
            if (sourceEntity != null && AVPPredicates.isFreeHost(this.ovomorph, sourceEntity) && this.ovomorph.getSensing().hasLineOfSight(sourceEntity)) {
                int baseDesire = (int)Math.abs((float)radius - vibrationInfo.distance()) * 2;
                Level level = this.ovomorph.level();
                BlockPos blockPos = this.ovomorph.blockPosition();
                int brightness = level.getRawBrightness(blockPos, 0);
                double bonusFactor = 5.0;
                double clampedBrightness = Math.clamp((double)brightness, bonusFactor, 15.0);
                int brightnessBonus = (int)(clampedBrightness / bonusFactor);
                this.addDesire(baseDesire * brightnessBonus);
            }
            this.lastVibrationInfo = vibrationInfo;
        }
    }

    public boolean wantsToHatch() {
        return this.desireToHatch.get() == 100;
    }

    private void addDesire(int desireAmount) {
        this.desireToHatch.set(Math.clamp((long)(this.desireToHatch.get() + desireAmount), 0, 100));
    }
}

