/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.parasite;

import com.alien.common.gameplay.entity.living.alien.parasite.Parasite;
import com.alien.common.model.alien.FreeMob;
import com.alien.common.model.alien.Host;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.registry.key.AVPDamageTypeKeys;
import com.avp.common.util.AVPPredicates;
import com.lib.common.network.DataAccessor;
import java.util.Objects;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;

public class ParasiteAttachmentManager {
    private final Parasite parasite;
    private final DataAccessor<Integer> ticksAttachedToHost;

    public ParasiteAttachmentManager(Parasite parasite) {
        this.parasite = parasite;
        this.ticksAttachedToHost = new DataAccessor<Integer>(parasite, AVPDataKeys.PARASITE_TICKS_ATTACHED_TO_HOST);
    }

    public void tick() {
        if (this.parasite.level().isClientSide) {
            return;
        }
        LivingEntity host = this.getHost();
        if (!this.isAttachedToHost()) {
            this.ticksAttachedToHost.reset();
            if (host instanceof Mob) {
                Mob mob = (Mob)host;
                ((FreeMob)mob).restoreFreedom();
            }
            return;
        }
        Objects.requireNonNull(host);
        if (!AVPPredicates.isHost((Entity)host)) {
            this.parasite.unRide();
            if (host instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)host;
                serverPlayer.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)host));
            }
            return;
        }
        if (this.parasite.isDeadOrDying()) {
            this.parasite.unRide();
            return;
        }
        int effectTimeInTicks = 80;
        host.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, effectTimeInTicks, 3, true, false, true));
        host.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, effectTimeInTicks, 3, true, false, true));
        host.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, effectTimeInTicks, 3, true, false, true));
        double falloffTimeInTicks = (host instanceof ServerPlayer ? 1.5 : 2.5) * 20.0 * 60.0;
        if (this.ticksAttachedToHost() < 200) {
            host.hurt(this.parasite.damageSources().source(AVPDamageTypeKeys.SMOTHERING), 0.01f);
        } else if ((double)this.ticksAttachedToHost() > falloffTimeInTicks) {
            this.parasite.stopRiding();
            if (host instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)host;
                player.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)host));
            }
        } else {
            host.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, effectTimeInTicks, 3, true, false, true));
            host.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, effectTimeInTicks, 100, true, false, true));
            if (host instanceof Mob) {
                Mob mob = (Mob)host;
                ((FreeMob)mob).removeFreedom();
            }
            if (this.ticksAttachedToHost() >= 400 && this.parasite.isFertile.get().booleanValue()) {
                ((Host)host).implantEmbryo(this.parasite);
                this.parasite.isFertile.set(false);
            }
        }
        host.setAirSupply(host.getMaxAirSupply());
        this.ticksAttachedToHost.set(this.ticksAttachedToHost.get() + 1);
    }

    public void restore() {
        this.parasite.isFertile.set(true);
    }

    @Nullable
    public LivingEntity getHost() {
        LivingEntity livingEntity;
        Entity entity = this.parasite.getVehicle();
        return entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
    }

    public boolean isAttachedToHost() {
        return this.getHost() != null && this.parasite.isAlive();
    }

    public int ticksAttachedToHost() {
        return this.ticksAttachedToHost.get();
    }
}

