/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph;

import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.avp.common.gameplay.ai.goal.WaterMoveControl;
import com.avp.common.gameplay.ai.goal.combat.DelayedAttackGoal;
import com.avp.common.gameplay.ai.path.CrawlPathNodeEvaluator;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.NotNull;

public class XenomorphNavigationManager {
    private final GroundPathNavigation groundNavigation;
    private final MoveControl groundMoveControl;
    private final WaterBoundPathNavigation waterNavigation;
    private final WaterMoveControl waterMoveControl;
    private final Goal groundAttackGoal;
    private final Goal waterAttackGoal;

    public XenomorphNavigationManager(Xenomorph xenomorph, MoveControl moveControl) {
        this.groundAttackGoal = new DelayedAttackGoal((PathfinderMob)xenomorph, xenomorph.getPursuitSpeedModifier(), false, xenomorph.getAttackDelayInTicks(), xenomorph::runAttackAnimations);
        this.groundMoveControl = moveControl;
        this.groundNavigation = new GroundPathNavigation(this, (Mob)xenomorph, xenomorph.level()){

            @NotNull
            protected PathFinder createPathFinder(int i) {
                this.nodeEvaluator = new CrawlPathNodeEvaluator();
                this.nodeEvaluator.setCanPassDoors(true);
                this.nodeEvaluator.setCanOpenDoors(true);
                this.nodeEvaluator.setCanWalkOverFences(true);
                return new PathFinder(this.nodeEvaluator, i);
            }
        };
        xenomorph.setPathfindingMalus(PathType.WATER, 0.0f);
        this.waterAttackGoal = new DelayedAttackGoal((PathfinderMob)xenomorph, 2.0, false, 7, xenomorph::runAttackAnimations);
        this.waterMoveControl = new WaterMoveControl((PathfinderMob)xenomorph);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)xenomorph, xenomorph.level());
    }

    public void switchToGround(Xenomorph xenomorph, int priority, GoalSelector goalSelector) {
        goalSelector.removeGoal(this.waterAttackGoal);
        goalSelector.addGoal(priority, this.groundAttackGoal);
        xenomorph.setMoveControl(this.groundMoveControl);
        xenomorph.setNavigation((PathNavigation)this.groundNavigation);
    }

    public void switchToWater(Xenomorph xenomorph, int priority, GoalSelector goalSelector) {
        goalSelector.removeGoal(this.groundAttackGoal);
        goalSelector.addGoal(priority, this.waterAttackGoal);
        xenomorph.setMoveControl(this.waterMoveControl);
        xenomorph.setNavigation((PathNavigation)this.waterNavigation);
    }
}

