/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.boiler;

import com.alien.common.gameplay.ai.InvestigateVibrationGoal;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.boiler.BoilerAnimationDispatcher;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.resin.ResinData;
import com.alien.common.registry.init.AlienEntityTypes;
import com.alien.common.util.AcidBleedUtil;
import com.avp.AVP;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Boiler
extends Xenomorph {
    private final BoilerAnimationDispatcher animationDispatcher = new BoilerAnimationDispatcher(this);

    public static AttributeSupplier.Builder createBoilerAttributes() {
        return Boiler.applyFrom(AVP.config.statsConfigs.BOILER_STATS, Monster.createMonsterAttributes());
    }

    public Boiler(EntityType<? extends Boiler> entityType, Level level) {
        super((EntityType<? extends Xenomorph>)entityType, level);
        this.config = AVP.config.statsConfigs.BOILER_STATS;
    }

    @Override
    @Nullable
    public EntityType<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Boiler.getType(alienVariant);
    }

    @Override
    @Nullable
    protected ResinData createResinData() {
        return null;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new InvestigateVibrationGoal(this));
    }

    @Override
    protected boolean canTargetInitially(LivingEntity target) {
        return target.distanceToSqr((Entity)this) <= 16.0 && super.canTargetInitially(target);
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        float radius = 2.0f;
        this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), radius, Level.ExplosionInteraction.MOB);
        this.triggerOnDeathMobEffects(Entity.RemovalReason.KILLED);
        this.discard();
        this.getBlockArea(this.blockPosition(), (int)radius, (int)radius, (int)radius).stream().filter(blockPos -> {
            BlockState blockState = this.level().getBlockState(blockPos);
            return blockState.isAir() || blockState.canBeReplaced();
        }).forEach(blockPos -> AcidBleedUtil.spawnAcid((LivingEntity)this, 3.0f, blockPos.getCenter()));
        return true;
    }

    private List<BlockPos> getBlockArea(BlockPos center, int radiusX, int radiusY, int radiusZ) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int dx = -radiusX; dx <= radiusX; ++dx) {
            for (int dy = -radiusY; dy <= radiusY; ++dy) {
                for (int dz = -radiusZ; dz <= radiusZ; ++dz) {
                    positions.add(center.offset(dx, dy, dz));
                }
            }
        }
        return positions;
    }

    @Override
    protected void addDigToTargetGoal() {
    }

    @Override
    public void runAttackAnimations() {
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.BOILER_STATS.healthRegenPerSecond;
    }

    @Override
    public Integer getMaxJellyToGrowth() {
        return null;
    }

    public BoilerAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    public static EntityType<? extends Alien> getType(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.BOILER.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_BOILER.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_BOILER.get();
            case AlienVariant.IRRADIATED -> null;
        };
    }
}

