/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.queen;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.drone.Drone;
import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.OvipositorManager;
import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.QueenAnimationDispatcher;
import com.alien.common.gameplay.level.saveddata.StrainLeakData;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.resin.ResinData;
import com.alien.common.registry.init.AlienEntityTypes;
import com.avp.AVP;
import com.avp.common.gameplay.ai.goal.DigToTargetGoal;
import com.avp.common.gameplay.ai.goal.QueenLayEggGoal;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.EntityUtil;
import com.avp.server.ServerLevelManagerAccessor;
import com.lib.common.util.PlayerUtil;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Queen
extends Xenomorph {
    private final QueenAnimationDispatcher animationDispatcher = new QueenAnimationDispatcher(this);
    private final OvipositorManager ovipositorManager = new OvipositorManager(this);

    public static AttributeSupplier.Builder createQueenAttributes() {
        return Queen.applyFrom(AVP.config.statsConfigs.QUEEN_STATS, Monster.createMonsterAttributes());
    }

    public Queen(EntityType<? extends Queen> entityType, Level level) {
        super((EntityType<? extends Xenomorph>)entityType, level);
        this.config = AVP.config.statsConfigs.QUEEN_STATS;
    }

    @Override
    @Nullable
    public EntityType<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Queen.getType(alienVariant);
    }

    @Override
    @Nullable
    protected ResinData createResinData() {
        return new ResinData(0, 128, 1, AVP.config.statsConfigs.QUEEN_STATS.nestTickrate);
    }

    @Override
    public void tick() {
        super.tick();
        this.ovipositorManager.tick();
    }

    @Override
    protected boolean canEntityRideAlien(@NotNull Entity passenger) {
        return Objects.equals(passenger.getType(), AlienEntityTypes.OVIPOSITOR.get());
    }

    protected void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (passenger.getType() == AlienEntityTypes.OVIPOSITOR.get()) {
            Vec3 relativePos = EntityUtil.getRelativePosition((LivingEntity)this, 3.0, 0.01, 5.25);
            callback.accept(passenger, relativePos.x, relativePos.y, relativePos.z);
            return;
        }
        super.positionRider(passenger, callback);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor serverLevelAccessor, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.NATURAL) {
            this.applyNaturalSpawnEffects();
        }
        return super.finalizeSpawn(serverLevelAccessor, difficulty, spawnType, spawnGroupData);
    }

    private void applyNaturalSpawnEffects() {
        Level level = this.level();
        if (level.isClientSide) {
            return;
        }
        this.alertPlayersOfSpawn();
        this.spawnGuards();
        this.resetQueenSpawnCooldown();
        StrainLeakData.getOrCreate(level).ifSome(strainLeakData -> strainLeakData.add(this.getVariant(), -1));
    }

    private void alertPlayersOfSpawn() {
        for (ServerPlayer player : PlayerUtil.getTrackingPlayers((Entity)this)) {
            player.playNotifySound(AVPSoundEvents.ENTITY_QUEEN_SCREAM.get(), SoundSource.MASTER, 1.0f, 1.0f);
            player.sendSystemMessage((Component)Component.literal((String)"A scream from the depths sends chills down your spine...").withStyle(new ChatFormatting[]{AlienVariantTypes.getFor(this).chatColor(), ChatFormatting.ITALIC}));
        }
    }

    private void spawnGuards() {
        EntityType<? extends Alien> droneType = Drone.getType(this.getVariant());
        for (int i = 0; i < 4; ++i) {
            Alien drone = (Alien)droneType.spawn((ServerLevel)this.level(), this.blockPosition(), MobSpawnType.NATURAL);
            if (drone == null) continue;
            drone.setPersistenceRequired();
        }
    }

    private void resetQueenSpawnCooldown() {
        ((ServerLevelManagerAccessor)this.level()).avp$getServerLevelManager().getQueenSpawnCooldown().reset();
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new QueenLayEggGoal(this));
    }

    @Override
    protected void addDigToTargetGoal() {
        this.goalSelector.addGoal(5, (Goal)new DigToTargetGoal((Mob)this, 32.0, 4, () -> !Objects.requireNonNull(this.ovipositorManager).hasOvipositor()));
    }

    @Override
    public float maxUpStep() {
        return 2.5f;
    }

    @Override
    @Nullable
    protected SoundEvent getAmbientSound() {
        return AVPSoundEvents.ENTITY_QUEEN_IDLE.get();
    }

    @Override
    @NotNull
    protected SoundEvent getDeathSound() {
        return AVPSoundEvents.ENTITY_QUEEN_DEATH.get();
    }

    @Override
    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return AVPSoundEvents.ENTITY_QUEEN_HURT.get();
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.QUEEN_STATS.healthRegenPerSecond;
    }

    @Override
    public void runAttackAnimations() {
        int attackType = this.random.nextInt(0, 3);
        this.playSound(AVPSoundEvents.ENTITY_XENOMORPH_ATTACK.get(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        switch (attackType) {
            case 0: {
                this.animationDispatcher.swipeDownAttack();
                break;
            }
            case 1: {
                this.animationDispatcher.backhandAttack();
                break;
            }
            default: {
                this.animationDispatcher.tailStrikeAttack();
            }
        }
    }

    @Override
    protected void doPush(@NotNull Entity entity) {
        if (!this.ovipositorManager.hasOvipositor() || !entity.getType().is(AVPEntityTypeTags.ALIENS)) {
            super.doPush(entity);
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    @Override
    public boolean isPersistenceRequired() {
        return true;
    }

    public void checkDespawn() {
        super.checkDespawn();
    }

    @Override
    public Integer getMaxJellyToGrowth() {
        return null;
    }

    public QueenAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    public OvipositorManager getOvipositorManager() {
        return this.ovipositorManager;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.ovipositorManager.load(compoundTag);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        this.ovipositorManager.save(compoundTag);
    }

    public static EntityType<? extends Alien> getType(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.QUEEN.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_QUEEN.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_QUEEN.get();
            case AlienVariant.IRRADIATED -> AlienEntityTypes.IRRADIATED_QUEEN.get();
        };
    }
}

