/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.ai.task.impl;

import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.hive.ai.task.HiveTask;
import com.alien.common.gameplay.hive.membership.HiveLeadershipManager;
import com.alien.common.gameplay.hive.membership.HiveMembershipManager;
import com.alien.common.gameplay.hive.util.HiveLeaderDispositionUtil;
import com.alien.common.model.hive.HiveMemberData;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.just.core.functional.option.Option;
import java.util.UUID;
import net.minecraft.world.entity.EntityType;

public class PickBestLeaderTask
extends HiveTask {
    private static final int TWENTY_SECONDS_IN_TICKS = 200;

    public PickBestLeaderTask(Hive hive) {
        super(hive);
    }

    @Override
    public boolean canRun() {
        return this.hive.ageInTicks() % 200 == 0;
    }

    @Override
    public void run() {
        HiveMembershipManager membershipManager = this.hive.getMembershipManager();
        HiveLeadershipManager leadershipManager = this.hive.getLeadershipManager();
        UUID candidateUUID = leadershipManager.getLeaderIdOrNull();
        HiveMemberData candidateHiveMemberData = (HiveMemberData)membershipManager.getMemberData(candidateUUID).unwrapOr(null);
        for (UUID contestantUUID : membershipManager.getMemberUUIDs()) {
            EntityType candidateType;
            HiveMemberData contestantHiveMemberData;
            EntityType contestantType;
            Option<HiveMemberData> contestantHiveMemberDataOption = membershipManager.getMemberData(contestantUUID);
            if (contestantHiveMemberDataOption.isNone() || (contestantType = (EntityType)(contestantHiveMemberData = (HiveMemberData)contestantHiveMemberDataOption.unwrap()).getEntityType().unwrapOr(null)) == null || !contestantType.is(AVPEntityTypeTags.XENOMORPHS)) continue;
            EntityType entityType = candidateType = candidateHiveMemberData == null ? null : (EntityType)candidateHiveMemberData.getEntityType().unwrapOr(null);
            if (candidateHiveMemberData == null || candidateType == null) {
                candidateUUID = contestantUUID;
                candidateHiveMemberData = contestantHiveMemberData;
                continue;
            }
            if (!HiveLeaderDispositionUtil.isLeftLowerDisposition(candidateType, contestantType)) continue;
            candidateUUID = contestantUUID;
            candidateHiveMemberData = contestantHiveMemberData;
        }
        leadershipManager.setLeaderId(candidateUUID);
    }
}

