/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.ai.task.impl.balance;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.Queen;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.hive.ai.task.impl.balance.BalanceHiveTask;
import com.alien.common.model.hive.HiveMemberData;
import com.just.core.functional.option.Option;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.EntityType;

public class BalanceQueenHiveTask
extends BalanceHiveTask {
    public BalanceQueenHiveTask(Hive hive) {
        super(hive);
    }

    @Override
    public void run() {
        EntityType<? extends Alien> queenEntityType;
        Map<EntityType<?>, List<Map.Entry<UUID, HiveMemberData>>> membersByType = this.hive.getMembershipManager().getMembersByEntityType();
        List queens = membersByType.getOrDefault(queenEntityType = Queen.getType(this.hive.getVariant()), List.of());
        if (!queens.isEmpty()) {
            return;
        }
        this.hive.getLeadershipManager().getLeader().ifSome(hiveLeader -> {
            if (!(hiveLeader instanceof Xenomorph)) {
                return;
            }
            Xenomorph xenomorph = (Xenomorph)hiveLeader;
            Option<HiveMemberData> hiveLeaderDataOption = this.hive.getMembershipManager().getMemberData(xenomorph.getUUID());
            hiveLeaderDataOption.ifSome($ -> this.growXenomorph(xenomorph));
        });
    }
}

