/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.model.alien.variant;

import com.just.core.functional.option.Option;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum AlienVariant {
    NORMAL(0),
    NETHER(1),
    ABERRANT(2),
    IRRADIATED(3);

    public static final AlienVariant[] VALUES;
    private static final Map<Integer, AlienVariant> BY_ID;
    private final int id;

    public static Option<AlienVariant> getById(int id) {
        return Option.ofNullable((Object)((Object)BY_ID.get(id)));
    }

    private AlienVariant(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    static {
        VALUES = AlienVariant.values();
        BY_ID = Arrays.stream(AlienVariant.values()).collect(Collectors.toMap(AlienVariant::getId, Function.identity()));
    }
}

