/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.util;

import com.alien.common.gameplay.entity.acid.Acid;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.registry.init.AlienEntityTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AcidBleedUtil {
    public static void spawnAcid(LivingEntity livingEntity, float damage, Vec3 randomPos) {
        Level level = livingEntity.level();
        EntityType<Acid> acidEntityType = AlienEntityTypes.ACID.get();
        Acid acidEntity = (Acid)acidEntityType.create(level);
        if (acidEntity == null) {
            return;
        }
        if (livingEntity instanceof Alien) {
            Alien alien = (Alien)livingEntity;
            acidEntity.setNetherAfflicted(alien.isNetherAfflicted());
            acidEntity.setIrradiated(alien.isIrradiated());
        }
        float quarterHealth = Math.max(livingEntity.getMaxHealth() / 4.0f, 1.0f);
        float factor = damage / quarterHealth;
        acidEntity.moveTo(randomPos, livingEntity.getYRot(), livingEntity.getXRot());
        level.addFreshEntity((Entity)acidEntity);
        int inverseMultiplier = (int)Mth.map((float)livingEntity.getHealth(), (float)0.0f, (float)livingEntity.getMaxHealth(), (float)1.0f, (float)10.0f);
        int clampedInverseMultiplier = Math.clamp((long)inverseMultiplier, 1, 5);
        float multiplier = factor * (float)(10 - clampedInverseMultiplier);
        acidEntity.setMultiplier((int)multiplier);
    }

    @NotNull
    public static Vec3 computeRandomPosFromBoundingBox(LivingEntity livingEntity) {
        RandomSource random = livingEntity.getRandom();
        AABB box = livingEntity.getBoundingBox();
        Vec3 pos = livingEntity.position();
        int xSize = (int)Math.ceil(box.maxX - box.minX);
        int zSize = (int)Math.ceil(box.maxZ - box.minZ);
        int randomX = random.nextInt(xSize + 1) * (random.nextBoolean() ? -1 : 1);
        int randomZ = random.nextInt(zSize + 1) * (random.nextBoolean() ? -1 : 1);
        return pos.add((double)randomX, 0.0, (double)randomZ);
    }
}

