/*
 * Decompiled with CFR 0.152.
 */
package com.avp.client.compat.jei;

import com.avp.client.compat.jei.AVPJEIPlugin;
import com.avp.common.registry.init.block.AVPBlocks;
import com.human.common.gameplay.recipe.IndustrialFurnaceRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndustrialCategory
implements IRecipeCategory<IndustrialFurnaceRecipe> {
    public IGuiHelper guiHelper;

    public IndustrialCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    public int getHeight() {
        return 54;
    }

    public int getWidth() {
        return 82;
    }

    @NotNull
    public RecipeType<IndustrialFurnaceRecipe> getRecipeType() {
        return AVPJEIPlugin.INDUSTRIAL_FURNACE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return AVPBlocks.INDUSTRIAL_FURNACE.get().getName();
    }

    @Nullable
    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)AVPBlocks.INDUSTRIAL_FURNACE.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IndustrialFurnaceRecipe recipe, @NotNull IFocusGroup focuses) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        builder.addInputSlot(1, 19).setStandardSlotBackground().addIngredients((Ingredient)recipe.getIngredients().getFirst());
        builder.addOutputSlot(61, 19).setOutputSlotBackground().addItemStack(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, @NotNull IndustrialFurnaceRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addAnimatedRecipeArrow(recipe.getCookingTime()).setPosition(26, 17);
    }

    public boolean isHandled(@NotNull IndustrialFurnaceRecipe recipe) {
        return super.isHandled((Object)recipe);
    }
}

