/*
 * Decompiled with CFR 0.152.
 */
package com.avp.client.network;

import com.avp.common.network.packet.S2CBulletHitBlockPayload;
import com.avp.common.network.packet.S2CEntityDataSyncPayload;
import com.avp.common.network.packet.S2CGunRecoilPayload;
import com.lib.common.network.DataContainer;
import com.lib.common.network.DataUser;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class AVPClientListener {
    public static void handleBulletHitBlockPayload(S2CBulletHitBlockPayload bulletHitBlockPayload) {
        BlockPos blockPos = bulletHitBlockPayload.blockPos();
        Direction direction = bulletHitBlockPayload.direction();
        for (int i = 0; i < 16; ++i) {
            Minecraft.getInstance().particleEngine.crack(blockPos, direction);
        }
    }

    public static void handleGunRecoil(S2CGunRecoilPayload gunRecoilPayload, Player player) {
        Level level = player.level();
        float baseRecoilX = level.getRandom().nextBoolean() ? 1.0f : -1.0f;
        player.turn((double)(baseRecoilX * 2.0f), (double)(-gunRecoilPayload.recoil() * 2.0f));
    }

    public static void handleEntityDataSync(S2CEntityDataSyncPayload entityDataSyncPayload, Player player) {
        Entity targetEntity = player.level().getEntity(entityDataSyncPayload.entityId());
        if (targetEntity == null) {
            return;
        }
        DataContainer dataContainer = ((DataUser)targetEntity).getDataContainer();
        entityDataSyncPayload.rawDataSyncMap().rawDataById().forEach(dataContainer::set);
    }

    private AVPClientListener() {
        throw new UnsupportedOperationException();
    }
}

