/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.ai.goal;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class WaterMoveControl
extends MoveControl {
    private final PathfinderMob pathfinderMob;

    public WaterMoveControl(PathfinderMob pathfinderMob) {
        super((Mob)pathfinderMob);
        this.pathfinderMob = pathfinderMob;
    }

    public void tick() {
        LivingEntity livingEntity = this.pathfinderMob.getTarget();
        if (this.pathfinderMob.isUnderWater()) {
            if (livingEntity != null && livingEntity.getY() > this.pathfinderMob.getY()) {
                this.pathfinderMob.setDeltaMovement(this.pathfinderMob.getDeltaMovement().add(0.0, 0.002, 0.0));
            }
            if (this.operation != MoveControl.Operation.MOVE_TO || this.pathfinderMob.getNavigation().isDone()) {
                this.pathfinderMob.setSpeed(0.0f);
                return;
            }
            double d = this.wantedX - this.pathfinderMob.getX();
            double e = this.wantedY - this.pathfinderMob.getY();
            double f = this.wantedZ - this.pathfinderMob.getZ();
            double g = Math.sqrt(d * d + e * e + f * f);
            e /= g;
            float h = (float)(Mth.atan2((double)f, (double)d) * 180.0 / 3.1415927410125732) - 90.0f;
            this.pathfinderMob.setYRot(this.rotlerp(this.pathfinderMob.getYRot(), h, 90.0f));
            this.pathfinderMob.yBodyRot = this.pathfinderMob.getYRot();
            float i = (float)(this.speedModifier * this.pathfinderMob.getAttributeValue(Attributes.MOVEMENT_SPEED));
            float j = Mth.lerp((float)0.125f, (float)this.pathfinderMob.getSpeed(), (float)i);
            this.pathfinderMob.setSpeed(j);
            this.pathfinderMob.setDeltaMovement(this.pathfinderMob.getDeltaMovement().add((double)j * d * 0.005, (double)j * e * 0.1, (double)j * f * 0.005));
        } else {
            if (!this.pathfinderMob.onGround()) {
                this.pathfinderMob.setDeltaMovement(this.pathfinderMob.getDeltaMovement().add(0.0, -0.008, 0.0));
            }
            super.tick();
        }
    }
}

