/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.worldgen.biome;

import com.avp.common.registry.init.block.CoreBlocks;
import com.avp.common.registry.key.AVPBiomeKeys;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;

public class NukedAshPlacement {
    public void tick(ServerLevel serverLevel) {
        if (serverLevel.random.nextInt(100) != 0) {
            return;
        }
        List players = serverLevel.players();
        if (players.isEmpty()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)players.get(serverLevel.random.nextInt(players.size()));
        if (player.isSpectator()) {
            return;
        }
        if (serverLevel.getBiome(player.blockPosition()).is(AVPBiomeKeys.NUKED_BIOME)) {
            ChunkPos playerChunkPos = player.chunkPosition();
            RandomSource random = serverLevel.random;
            int radius = 3;
            for (int chunkX = playerChunkPos.x - radius; chunkX <= playerChunkPos.x + radius; ++chunkX) {
                for (int chunkZ = playerChunkPos.z - radius; chunkZ <= playerChunkPos.z + radius; ++chunkZ) {
                    if (!serverLevel.hasChunk(chunkX, chunkZ)) continue;
                    for (int i = 0; i < 10; ++i) {
                        int z;
                        int y;
                        int x = chunkX * 16 + random.nextInt(16);
                        BlockPos blockPos = new BlockPos(x, y = serverLevel.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z = chunkZ * 16 + random.nextInt(16)) - 1, z);
                        if (!serverLevel.getBiome(blockPos).is(AVPBiomeKeys.NUKED_BIOME)) continue;
                        BlockState currentBlock = serverLevel.getBlockState(blockPos);
                        BlockState currentBlockAbove = serverLevel.getBlockState(blockPos.above());
                        if (!currentBlock.isSolidRender((BlockGetter)serverLevel, blockPos) || currentBlock.liquid() || !currentBlockAbove.isAir()) continue;
                        BlockState ashBlock = (BlockState)CoreBlocks.ASH_BLOCK.get().defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(1));
                        serverLevel.setBlock(blockPos.above(), ashBlock, 3);
                    }
                }
            }
        }
    }
}

