/*
 * Decompiled with CFR 0.152.
 */
package com.avp.mixin;

import com.avp.common.registry.tag.AVPItemTags;
import com.avp.common.util.AVPPredicates;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity_ApplyArmorEffects
extends Entity {
    @Shadow
    protected abstract int increaseAirSupply(int var1);

    protected MixinLivingEntity_ApplyArmorEffects(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void tick(CallbackInfo callbackInfo) {
        LivingEntity self = (LivingEntity)LivingEntity.class.cast((Object)this);
        boolean supplyAir = false;
        if (this.isWearingFullMK50SuitArmor(self)) {
            self.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 5, 0, true, false, true));
            supplyAir = true;
        } else if (this.isWearingFullPressureSuitArmor(self)) {
            supplyAir = true;
        } else if (this.isWearingFullFireResistantArmor(self)) {
            self.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 5, 0, true, false, true));
        } else if (this.isWearingFullPredatorArmor(self)) {
            self.addEffect(new MobEffectInstance(MobEffects.JUMP, 5, 0, true, false, true));
            self.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 5, 0, true, false, true));
        }
        if (supplyAir) {
            this.setAirSupply(this.increaseAirSupply(this.getAirSupply()));
        }
    }

    @Unique
    private boolean isWearingFullFireResistantArmor(LivingEntity self) {
        return AVPPredicates.hasFullArmorSetMatching(self, itemStack -> itemStack.is(AVPItemTags.FIRE_RESISTANT_ARMORS));
    }

    @Unique
    private boolean isWearingFullPredatorArmor(LivingEntity self) {
        return AVPPredicates.hasFullArmorSetMatching(self, itemStack -> itemStack.is(AVPItemTags.PREDATOR_ARMORS));
    }

    @Unique
    private boolean isWearingFullMK50SuitArmor(LivingEntity self) {
        return AVPPredicates.hasFullArmorSetMatching(self, itemStack -> itemStack.is(AVPItemTags.MK50_ARMOR));
    }

    @Unique
    private boolean isWearingFullPressureSuitArmor(LivingEntity self) {
        return AVPPredicates.hasFullArmorSetMatching(self, itemStack -> itemStack.is(AVPItemTags.PRESSURE_ARMOR));
    }
}

