/*
 * Decompiled with CFR 0.152.
 */
package com.avp.mixin.client;

import com.avp.common.util.AVPPredicates;
import com.avp.common.util.AmmunitionIndicatorUtil;
import com.human.common.gameplay.item.GunItem;
import com.human.common.registry.init.HumanDataComponents;
import com.human.common.registry.init.item.HumanGunItems;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class MixinPlayerEntity_LowAmmunitionIndicator
extends LivingEntity {
    @Unique
    private long lastUpdateTimeMillis = 0L;
    @Unique
    private AmmunitionIndicatorUtil.DisplayState currentDisplayState = AmmunitionIndicatorUtil.DisplayState.NOTHING;

    protected MixinPlayerEntity_LowAmmunitionIndicator(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tellPlayer(CallbackInfo ci) {
        GunItem gunItem;
        Item item;
        Player self = (Player)Player.class.cast((Object)this);
        ItemStack mainHandItem = self.getMainHandItem();
        if (!self.level().isClientSide || AVPPredicates.IS_IMMORTAL.test((LivingEntity)self) || mainHandItem.isEmpty() || !((item = mainHandItem.getItem()) instanceof GunItem) || (gunItem = (GunItem)item) == HumanGunItems.OLD_PAINLESS.get()) {
            return;
        }
        this.displayAmmunitionIndicator(gunItem, mainHandItem, self);
    }

    @Unique
    private void displayAmmunitionIndicator(GunItem gunItem, ItemStack mainHandItem, Player player) {
        boolean shouldUpdate;
        int currentAmmunition = (Integer)mainHandItem.getOrDefault(HumanDataComponents.AMMUNITION.get(), (Object)0);
        int maximumAmmunition = gunItem.getGunConfig().maximumAmmunition();
        AmmunitionIndicatorUtil.DisplayState previousDisplayState = this.currentDisplayState;
        this.setDisplayStateForAmmunitionState(currentAmmunition, maximumAmmunition);
        long currentTime = System.currentTimeMillis();
        boolean bl = shouldUpdate = this.currentDisplayState != previousDisplayState || currentTime - this.lastUpdateTimeMillis >= 1000L;
        if (!shouldUpdate) {
            return;
        }
        this.lastUpdateTimeMillis = currentTime;
        player.displayClientMessage(AmmunitionIndicatorUtil.DISPLAY_STATE_COMPONENT_MAP.get((Object)this.currentDisplayState), true);
    }

    @Unique
    private void setDisplayStateForAmmunitionState(int currentAmmunition, int maximumAmmunition) {
        this.currentDisplayState = currentAmmunition == 0 ? AmmunitionIndicatorUtil.DisplayState.NO_AMMUNITION : ((double)currentAmmunition < (double)maximumAmmunition * 0.2 ? AmmunitionIndicatorUtil.DisplayState.LOW_AMMUNITION : AmmunitionIndicatorUtil.DisplayState.NOTHING);
    }
}

