/*
 * Decompiled with CFR 0.152.
 */
package com.avp.neoforge.data;

import com.avp.AVPResources;
import com.avp.common.config.AVPConfig;
import com.avp.common.data.worldgen.AVPOres;
import com.avp.common.model.spawning.AVPEntitySpawnConfigData;
import com.avp.common.model.spawning.AVPEntitySpawnData;
import com.avp.common.registry.key.AVPPlacedFeatureKeys;
import com.avp.neoforge.data.AVPFeatureKeys;
import com.avp.neoforge.data.AVPNeoForgeDataMaps;
import com.avp.neoforge.data.BiomeFilterRegistryLookup;
import com.avp.neoforge.service.NeoForgeRegistryService;
import com.avp.service.Services;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.holdersets.AndHolderSet;
import net.neoforged.neoforge.registries.holdersets.NotHolderSet;

@EventBusSubscriber(modid="avp", bus=EventBusSubscriber.Bus.MOD)
public class AVPNeoForgeDatagen {
    private static final NeoForgeRegistryService REGISTRY = (NeoForgeRegistryService)Services.REGISTRY;

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new AVPNeoForgeDataMaps(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), output -> new DatapackBuiltinEntriesProvider(event.getGenerator().getPackOutput(), event.getLookupProvider(), new RegistrySetBuilder().add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, bootstrap -> {
            HolderGetter biomes = bootstrap.lookup(Registries.BIOME);
            HolderGetter placedFeatures = bootstrap.lookup(Registries.PLACED_FEATURE);
            BiomeFilterRegistryLookup biomes0 = new BiomeFilterRegistryLookup((HolderGetter<Biome>)biomes);
            HolderSet.Direct excludedBiomes = HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.DRIPSTONE_CAVES)});
            GenerationStep.Decoration underGround = GenerationStep.Decoration.UNDERGROUND_ORES;
            for (AVPEntitySpawnData<?> spawnData : REGISTRY.getEntitySpawnDataEntries()) {
                if (spawnData.isConfigDisabled()) continue;
                EntityType<?> entityType = spawnData.getEntityType();
                String entityTypePath = BuiltInRegistries.ENTITY_TYPE.getKey(entityType).getPath();
                ResourceKey spawnKey = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)AVPResources.location("add_spawns_" + entityTypePath));
                AVPEntitySpawnConfigData config = spawnData.getConfigData();
                AVPConfig.SpawnConfigs.SpawnSettings spawnSettings = config.spawnSettings();
                bootstrap.register(spawnKey, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(config.biomeTagKey()), List.of(new MobSpawnSettings.SpawnerData(entityType, spawnSettings.weight, spawnSettings.minGroupSize, spawnSettings.maxGroupSize))));
            }
            bootstrap.register(AVPFeatureKeys.ADD_AUTUNITE_GEODE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AVPPlacedFeatureKeys.AUTUNITE_GEODE)}), GenerationStep.Decoration.LOCAL_MODIFICATIONS));
            bootstrap.register(AVPFeatureKeys.ADD_BAUXITE_MIDDLE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AVPOres.BAUXITE_MIDDLE.placedFeatureKey())}), underGround));
            bootstrap.register(AVPFeatureKeys.ADD_BAUXITE_UPPER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AVPOres.BAUXITE_UPPER.placedFeatureKey())}), underGround));
            bootstrap.register(AVPFeatureKeys.ADD_GALENA, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AVPOres.GALENA.placedFeatureKey())}), underGround));
            bootstrap.register(AVPFeatureKeys.ADD_LITHIUM, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AVPOres.LITHIUM.placedFeatureKey())}), underGround));
            bootstrap.register(AVPFeatureKeys.ADD_MONAZITE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AVPOres.MONAZITE.placedFeatureKey())}), underGround));
            bootstrap.register(AVPFeatureKeys.ADD_SILICON_GRAVEL, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AVPOres.SILICON_GRAVEL.placedFeatureKey())}), underGround));
            bootstrap.register(AVPFeatureKeys.ADD_TITANIUM_LOWER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AVPOres.TITANIUM_LOWER.placedFeatureKey())}), underGround));
            bootstrap.register(AVPFeatureKeys.ADD_LEAD_SWAMP, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct(List.of(biomes.getOrThrow(Biomes.SWAMP), biomes.getOrThrow(Biomes.MANGROVE_SWAMP))), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AVPOres.LEAD_SWAMP.placedFeatureKey())}), underGround));
            bootstrap.register(AVPFeatureKeys.ADD_LITHIUM_DESERT, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct(List.of(biomes.getOrThrow(Biomes.DESERT), biomes.getOrThrow(Biomes.BADLANDS))), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AVPOres.LITHIUM_DESERT.placedFeatureKey())}), underGround));
            bootstrap.register(AVPFeatureKeys.ADD_MONAZITE_JUNGLE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_JUNGLE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AVPOres.MONAZITE_JUNGLE.placedFeatureKey())}), underGround));
            bootstrap.register(AVPFeatureKeys.ADD_ZINC, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new AndHolderSet(new HolderSet[]{biomes.getOrThrow(BiomeTags.IS_OVERWORLD), new NotHolderSet((HolderLookup.RegistryLookup)biomes0, (HolderSet)excludedBiomes)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AVPOres.ZINC.placedFeatureKey())}), underGround));
            bootstrap.register(AVPFeatureKeys.ADD_ZINC_DRIPSTONE_CAVES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.DRIPSTONE_CAVES)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AVPOres.ZINC_DRIPSTONE_CAVES.placedFeatureKey())}), underGround));
        }), Set.of("avp")));
    }

    private AVPNeoForgeDatagen() {
    }
}

