/*
 * Decompiled with CFR 0.152.
 */
package com.avp.neoforge.service;

import com.avp.common.model.spawning.AVPEntitySpawnData;
import com.avp.common.network.NetworkHandler;
import com.avp.common.network.PacketDirection;
import com.avp.common.registry.AVPDeferredHolder;
import com.avp.service.RegistryService;
import com.just.core.functional.tuple.Tuple2;
import com.just.core.functional.tuple.Tuple3;
import com.just.core.functional.tuple.Tuple4;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class NeoForgeRegistryService
implements RegistryService {
    private final Map<Registry<?>, DeferredRegister<?>> registryToDeferredRegisterMap = Stream.of(BuiltInRegistries.ARMOR_MATERIAL, BuiltInRegistries.BLOCK, BuiltInRegistries.BLOCK_ENTITY_TYPE, BuiltInRegistries.CREATIVE_MODE_TAB, BuiltInRegistries.DATA_COMPONENT_TYPE, BuiltInRegistries.DECORATED_POT_PATTERN, BuiltInRegistries.ENTITY_TYPE, BuiltInRegistries.GAME_EVENT, BuiltInRegistries.ITEM, BuiltInRegistries.MENU, BuiltInRegistries.MOB_EFFECT, BuiltInRegistries.PARTICLE_TYPE, BuiltInRegistries.POINT_OF_INTEREST_TYPE, BuiltInRegistries.RECIPE_SERIALIZER, BuiltInRegistries.RECIPE_TYPE, BuiltInRegistries.SOUND_EVENT, BuiltInRegistries.VILLAGER_PROFESSION).collect(Collectors.toMap(Function.identity(), NeoForgeRegistryService::createDeferredRegistry));
    private final List<Supplier<? extends Item>> azureLibItemIdentitySuppliers = new ArrayList<Supplier<? extends Item>>();
    private final List<Tuple4<Supplier<? extends ItemLike>, Float, Boolean, Boolean>> compostableData = new ArrayList<Tuple4<Supplier<? extends ItemLike>, Float, Boolean, Boolean>>();
    private final List<Tuple2<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>>> entityAttributeSupplierPairs = new ArrayList<Tuple2<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>>>();
    private final List<AVPEntitySpawnData<?>> entitySpawnDataEntries = new ArrayList();
    private final List<Tuple2<Supplier<? extends ItemLike>, Integer>> furnaceFuelPairs = new ArrayList<Tuple2<Supplier<? extends ItemLike>, Integer>>();
    private final List<LiteralArgumentBuilder<CommandSourceStack>> literalArgumentBuilders = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
    private final List<NetworkHandler<?>> networkHandlers = new ArrayList();
    private final List<PreparableReloadListener> reloadListeners = new ArrayList<PreparableReloadListener>();
    private final List<Tuple3<Supplier<VillagerProfession>, Integer, List<VillagerTrades.ItemListing>>> villagerTradeData = new ArrayList<Tuple3<Supplier<VillagerProfession>, Integer, List<VillagerTrades.ItemListing>>>();

    @NotNull
    private static <T> DeferredRegister<T> createDeferredRegistry(Registry<T> registry) {
        return DeferredRegister.create(registry, (String)"avp");
    }

    @Override
    public <T> AVPDeferredHolder<T> register(Registry<? super T> registry, String id, Supplier<? extends T> supplier) {
        DeferredRegister<?> deferredRegister = this.registryToDeferredRegisterMap.get(registry);
        if (deferredRegister == null) {
            throw new IllegalArgumentException("Unhandled registry: " + String.valueOf(registry));
        }
        return this.adapt(deferredRegister.register(id, supplier));
    }

    @Override
    public void registerCommand(LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder) {
        this.literalArgumentBuilders.add(literalArgumentBuilder);
    }

    @Override
    public void registerAzureLibIdentity(Supplier<? extends Item> itemSupplier) {
        this.azureLibItemIdentitySuppliers.add(itemSupplier);
    }

    @Override
    public void registerCompostableItem(Supplier<? extends ItemLike> itemLikeSupplier, float chance, boolean villagersCanCompost, boolean replace) {
        this.compostableData.add((Tuple4<Supplier<? extends ItemLike>, Float, Boolean, Boolean>)new Tuple4(itemLikeSupplier, (Object)Float.valueOf(chance), (Object)villagersCanCompost, (Object)replace));
    }

    @Override
    public void registerEntityAttributes(Supplier<? extends EntityType<? extends LivingEntity>> entityTypeSupplier, Supplier<AttributeSupplier.Builder> attributeSupplierBuilderSupplier) {
        this.entityAttributeSupplierPairs.add((Tuple2<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>>)new Tuple2(entityTypeSupplier, attributeSupplierBuilderSupplier));
    }

    @Override
    public <T extends Mob> void registerEntitySpawnData(AVPEntitySpawnData<T> spawnData) {
        this.entitySpawnDataEntries.add(spawnData);
    }

    @Override
    public void registerFurnaceFuel(Supplier<? extends ItemLike> itemLikeSupplier, int burnTimeInTicks) {
        this.furnaceFuelPairs.add((Tuple2<Supplier<? extends ItemLike>, Integer>)new Tuple2(itemLikeSupplier, (Object)burnTimeInTicks));
    }

    @Override
    public <T extends CustomPacketPayload> void registerPacketHandlers(NetworkHandler<T> networkHandler) {
        this.networkHandlers.add(networkHandler);
    }

    @Override
    public <T extends CustomPacketPayload> void registerPacketDirection(PacketDirection<T> packetDirection) {
    }

    @Override
    public PreparableReloadListener registerReloadListener(String id, PreparableReloadListener listener) {
        this.reloadListeners.add(listener);
        return listener;
    }

    @Override
    public void registerVillagerTrade(Supplier<VillagerProfession> villagerProfessionSupplier, int level, List<VillagerTrades.ItemListing> villagerTradeItemListings) {
        this.villagerTradeData.add((Tuple3<Supplier<VillagerProfession>, Integer, List<VillagerTrades.ItemListing>>)new Tuple3(villagerProfessionSupplier, (Object)level, villagerTradeItemListings));
    }

    private <T> AVPDeferredHolder<T> adapt(DeferredHolder<T, T> deferredHolder) {
        return new AVPDeferredHolder(deferredHolder, () -> deferredHolder);
    }

    public void initialize(IEventBus modBus) {
        this.registryToDeferredRegisterMap.values().forEach(deferredRegister -> deferredRegister.register(modBus));
    }

    public List<Supplier<? extends Item>> getAzureLibItemIdentitySuppliers() {
        return this.azureLibItemIdentitySuppliers;
    }

    public List<Tuple4<Supplier<? extends ItemLike>, Float, Boolean, Boolean>> getCompostableData() {
        return this.compostableData;
    }

    public List<Tuple2<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>>> getEntityAttributeSupplierPairs() {
        return this.entityAttributeSupplierPairs;
    }

    public List<AVPEntitySpawnData<?>> getEntitySpawnDataEntries() {
        return this.entitySpawnDataEntries;
    }

    public List<Tuple2<Supplier<? extends ItemLike>, Integer>> getFurnaceFuelPairs() {
        return this.furnaceFuelPairs;
    }

    public List<LiteralArgumentBuilder<CommandSourceStack>> getLiteralArgumentBuilders() {
        return this.literalArgumentBuilders;
    }

    public List<NetworkHandler<?>> getNetworkHandlers() {
        return this.networkHandlers;
    }

    public List<PreparableReloadListener> getReloadListeners() {
        return this.reloadListeners;
    }

    public List<Tuple3<Supplier<VillagerProfession>, Integer, List<VillagerTrades.ItemListing>>> getVillagerTradeData() {
        return this.villagerTradeData;
    }
}

