/*
 * Decompiled with CFR 0.152.
 */
package com.avp.service;

import com.avp.AVP;
import com.avp.service.BridgeService;
import com.avp.service.ClientNetworkingService;
import com.avp.service.ClientRegistryService;
import com.avp.service.EventService;
import com.avp.service.PlatformService;
import com.avp.service.RegistryService;
import com.avp.service.ServerNetworkingService;
import java.util.ServiceLoader;

public class Services {
    public static final BridgeService BRIDGE = Services.load(BridgeService.class);
    public static final ClientNetworkingService CLIENT_NETWORKING = Services.load(ClientNetworkingService.class);
    public static final ClientRegistryService CLIENT_REGISTRY = Services.load(ClientRegistryService.class);
    public static final EventService EVENT = Services.load(EventService.class);
    public static final PlatformService PLATFORM = Services.load(PlatformService.class);
    public static final RegistryService REGISTRY = Services.load(RegistryService.class);
    public static final ServerNetworkingService SERVER_NETWORKING = Services.load(ServerNetworkingService.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        AVP.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

