/*
 * Decompiled with CFR 0.152.
 */
package com.human.client.render.entity;

import com.human.common.gameplay.entity.nuke.PrimedNuke;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class NukeRenderer<T extends Entity>
extends EntityRenderer<T> {
    private final BlockRenderDispatcher blockRenderer;

    public NukeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void render(T nukeEntity, float partialTicks, float animationProgress, PoseStack poseStack, MultiBufferSource bufferSource, int lightLevel) {
        if (nukeEntity instanceof PrimedNuke) {
            PrimedNuke primedNuke = (PrimedNuke)((Object)nukeEntity);
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            boolean shouldFlash = primedNuke.getFuse() / 5 % 2 == 0;
            TntMinecartRenderer.renderWhiteSolidBlock((BlockRenderDispatcher)this.blockRenderer, (BlockState)primedNuke.getBlockState(), (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)lightLevel, (boolean)shouldFlash);
            poseStack.popPose();
        }
        super.render(nukeEntity, partialTicks, animationProgress, poseStack, bufferSource, lightLevel);
    }

    public boolean shouldRender(T livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

