/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.entity.power;

import com.avp.AVP;
import com.human.common.gameplay.power.PowerNode;
import com.human.common.gameplay.power.PowerSystem;
import com.human.common.gameplay.power.grid.PowerGridExploreUtil;
import com.human.common.gameplay.power.grid.PowerGridManager;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class PowerNodeBlockEntity
extends BlockEntity {
    private boolean hasInitialized = false;
    private final PowerNode powerNode;

    public PowerNodeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        PowerNodeBlockEntity powerNodeBlockEntity = this;
        if (!(powerNodeBlockEntity instanceof PowerNode)) {
            throw new IllegalStateException("Child of PowerNodeBlockEntity must be instance of PowerNode!");
        }
        PowerNode node = (PowerNode)((Object)powerNodeBlockEntity);
        this.powerNode = node;
    }

    public void serverTick(Level level, BlockPos blockPos, BlockState blockState) {
        if (!this.hasInitialized() && level != null && !level.isClientSide) {
            this.setHasInitialized(true);
            ServerLevel serverLevel = (ServerLevel)level;
            PowerGridManager manager = PowerSystem.get(serverLevel);
            manager.registerNode(blockPos, this.powerNode);
            AVP.LOGGER.debug("Starting BFS for PNBE at pos {}", (Object)blockPos);
            long start = System.currentTimeMillis();
            Set<BlockPos> connectedPositions = PowerGridExploreUtil.discover((Level)serverLevel, blockPos);
            AVP.LOGGER.debug("Finished BFS for PNBE at pos {} in {}ms", (Object)blockPos, (Object)(System.currentTimeMillis() - start));
            for (BlockPos pos : connectedPositions) {
                manager.union(blockPos, pos);
            }
        }
    }

    public void setRemoved() {
        Level level;
        if (!this.isRemoved() && (level = this.getLevel()) != null && !level.isClientSide) {
            PowerSystem.get((ServerLevel)level).unregisterNode(this.worldPosition, this.powerNode);
        }
        super.setRemoved();
    }

    public void setHasInitialized(boolean hasInitialized) {
        this.hasInitialized = hasInitialized;
    }

    public boolean hasInitialized() {
        return this.hasInitialized;
    }
}

