/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.entity.power.impl;

import com.avp.common.registry.init.AVPBlockEntityTypes;
import com.human.common.gameplay.block.entity.power.PowerNodeBlockEntity;
import com.human.common.gameplay.power.PowerNode;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BatteryBlockEntity
extends PowerNodeBlockEntity
implements PowerNode.PowerStore {
    private static final String NBT_STORED_POWER = "storedPower";
    private long storedPower;

    public BatteryBlockEntity(BlockPos pos, BlockState state) {
        super(AVPBlockEntityTypes.BATTERY.get(), pos, state);
    }

    @Override
    public long getRequestedPower() {
        return 0L;
    }

    @Override
    public long receivePower(long maxAmount) {
        this.storedPower += maxAmount;
        return 0L;
    }

    @Override
    public long getAvailablePower() {
        return this.storedPower;
    }

    @Override
    public long extractPower(long maxAmount) {
        long amountExtracted = Math.min(this.storedPower, maxAmount);
        this.storedPower -= amountExtracted;
        return amountExtracted;
    }

    @Override
    public long getStoredPower() {
        return this.storedPower;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putLong(NBT_STORED_POWER, this.storedPower);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.storedPower = tag.getLong(NBT_STORED_POWER);
    }
}

