/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.living.human;

import com.avp.common.config.AVPConfig;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.util.MovementAnalyzer;
import com.human.common.gameplay.entity.living.human.HumanFeatureManager;
import com.human.common.gameplay.entity.living.human.HumanNavigationManager;
import com.lib.common.network.DataAccessor;
import com.lib.common.network.DataUser;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHuman
extends PathfinderMob
implements DataUser {
    public final DataAccessor<Integer> beardVariant = new DataAccessor<Integer>(this, AVPDataKeys.MARINE_BEARD_VARIANT);
    public final DataAccessor<Integer> eyeColor = new DataAccessor<Integer>(this, AVPDataKeys.MARINE_EYE_COLOR);
    public final DataAccessor<Integer> hairColor = new DataAccessor<Integer>(this, AVPDataKeys.MARINE_HAIR_COLOR);
    public final DataAccessor<Integer> hairVariant = new DataAccessor<Integer>(this, AVPDataKeys.MARINE_HAIR_VARIANT);
    public final DataAccessor<Boolean> isMale = new DataAccessor<Boolean>(this, AVPDataKeys.MARINE_IS_MALE);
    public final DataAccessor<Integer> skinColor = new DataAccessor<Integer>(this, AVPDataKeys.MARINE_SKIN_COLOR);
    protected final MovementAnalyzer movementAnalyzer = new MovementAnalyzer((Entity)this);
    private final HumanNavigationManager navigationManager = new HumanNavigationManager(this, this.moveControl);
    private final HumanFeatureManager humanFeatureManager = new HumanFeatureManager(this);

    public static AttributeSupplier.Builder applyFrom(AVPConfig.StatsConfigs.AdvancedStats config, AttributeSupplier.Builder builder) {
        builder.add(Attributes.ARMOR, (double)config.armor);
        builder.add(Attributes.ARMOR_TOUGHNESS, (double)config.armorToughness);
        builder.add(Attributes.ATTACK_DAMAGE, (double)config.attackDamage);
        builder.add(Attributes.FOLLOW_RANGE, (double)config.followRange);
        builder.add(Attributes.KNOCKBACK_RESISTANCE, (double)config.knockbackResistance);
        builder.add(Attributes.MAX_HEALTH, (double)config.health);
        builder.add(Attributes.MOVEMENT_SPEED, (double)config.moveSpeed);
        return builder;
    }

    public AbstractHuman(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public int getAmbientSoundInterval() {
        return 120;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.EMPTY;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.GENERIC_DEATH;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return SoundEvents.GENERIC_HURT;
    }

    public abstract void runAttackAnimations();

    public void tick() {
        super.tick();
        this.movementAnalyzer.tick();
    }

    public void travel(@NotNull Vec3 vec3) {
        if (this.isControlledByLocalInstance() && this.isUnderWater()) {
            this.moveRelative(0.01f, vec3);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.8));
        } else {
            super.travel(vec3);
        }
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            if (this.isEffectiveAi() && this.isUnderWater()) {
                this.navigationManager.switchToWater(this, 4, this.goalSelector);
                this.setSwimming(true);
            } else {
                this.navigationManager.switchToGround(this, 4, this.goalSelector);
                this.setSwimming(false);
            }
        }
    }

    void setMoveControl(MoveControl moveControl) {
        this.moveControl = moveControl;
    }

    void setNavigation(PathNavigation navigation) {
        this.navigation = navigation;
    }

    public HumanFeatureManager getHumanFeatureManager() {
        return this.humanFeatureManager;
    }

    public Integer getBeardVariantOrNull() {
        return this.isMale.get() != false ? this.beardVariant.get() : null;
    }

    public void setBeardVariant(int variantIndex) {
        if (!this.isMale.get().booleanValue()) {
            return;
        }
        this.beardVariant.set(variantIndex);
    }
}

