/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.living.human.marine;

import com.avp.common.model.inventory.AVPInventory;
import com.human.common.gameplay.entity.living.human.marine.Marine;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.NBTSerializable;
import com.lib.common.gameplay.util.ItemUtil;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MarineInventory
implements AVPInventory,
InventoryCarrier,
NBTSerializable {
    private static final String PERSONAL_INVENTORY_KEY = "personalInventory";
    private static final String PRIMARY_INVENTORY_KEY = "primaryInventory";
    private final Marine marine;
    private final SimpleContainer personalInventory;
    private final SimpleContainer primaryInventory;

    public MarineInventory(Marine marine) {
        this.marine = marine;
        this.personalInventory = new SimpleContainer(9);
        this.primaryInventory = new SimpleContainer(27);
    }

    @NotNull
    public SimpleContainer getInventory() {
        return this.primaryInventory;
    }

    @Override
    public boolean canAddItem(ItemStack itemStack) {
        return this.primaryInventory.canAddItem(itemStack);
    }

    @Override
    public void forEach(Consumer<ItemStack> consumer) {
        this.personalInventory.getItems().forEach(consumer);
        this.primaryInventory.getItems().forEach(consumer);
    }

    @Override
    public void pickUpItem(ItemEntity itemEntity) {
        InventoryCarrier.pickUpItem((Mob)this.marine, (InventoryCarrier)this, (ItemEntity)itemEntity);
    }

    @Override
    public void removeItemType(Item item, int amount) {
        this.primaryInventory.removeItemType(item, amount);
    }

    @Override
    public Stream<ItemStack> stream() {
        return Stream.concat(this.personalInventory.getItems().stream(), this.primaryInventory.getItems().stream());
    }

    public ItemStack addPersonalItem(ItemStack itemStack) {
        return this.personalInventory.addItem(itemStack);
    }

    public void dropItems() {
        this.primaryInventory.removeAllItems().stream().map(itemStack -> ItemUtil.drop((LivingEntity)this.marine, itemStack, true, false)).flatMap(Option::toStream).forEach((? super T itemEntity) -> this.marine.level().addFreshEntity((Entity)itemEntity));
    }

    @Override
    public void load(CompoundTag compoundTag) {
        Level level = this.marine.level();
        this.personalInventory.fromTag(compoundTag.getList(PERSONAL_INVENTORY_KEY, 10), (HolderLookup.Provider)level.registryAccess());
        this.primaryInventory.fromTag(compoundTag.getList(PRIMARY_INVENTORY_KEY, 10), (HolderLookup.Provider)level.registryAccess());
    }

    @Override
    public void save(CompoundTag compoundTag) {
        Level level = this.marine.level();
        compoundTag.put(PERSONAL_INVENTORY_KEY, (Tag)this.personalInventory.createTag((HolderLookup.Provider)level.registryAccess()));
        compoundTag.put(PRIMARY_INVENTORY_KEY, (Tag)this.primaryInventory.createTag((HolderLookup.Provider)level.registryAccess()));
    }
}

