/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.living.human.marine.ai;

import com.human.common.gameplay.entity.living.human.marine.Marine;
import com.human.common.gameplay.item.GunItem;
import com.human.common.gameplay.item.gun.FireModeConfig;
import com.human.common.gameplay.item.gun.pipeline.GunShootContext;
import com.human.common.gameplay.item.gun.pipeline.GunShootResult;
import com.lib.common.gameplay.entity.ai.action.AttackAction;
import com.lib.common.gameplay.entity.ai.util.CombatResponse;
import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MarineRangedAttackAction
extends AttackAction<Marine> {
    private static final TypedIdentifier<Integer> COOLDOWN = new TypedIdentifier("cooldown");
    private static final TypedIdentifier<Integer> TICK_PROGRESS = new TypedIdentifier("tickProgress");

    public MarineRangedAttackAction() {
        super(CombatResponse.FightType.RANGED);
    }

    @Override
    protected void performAttack(Marine context, LivingEntity target, GOAPBlackboard blackboard) {
        ItemStack itemStack = context.getMainHandItem();
        Item item = itemStack.getItem();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            MarineRangedAttackAction.shootGun(context, target, blackboard, gunItem, itemStack);
        }
    }

    private static void shootGun(Marine context, LivingEntity target, GOAPBlackboard blackboard, GunItem gunItem, ItemStack itemStack) {
        FireModeConfig fireMode = gunItem.getGunConfig().getDefaultFireMode();
        int currentCooldown = blackboard.getOrDefault(COOLDOWN, 0) - 1;
        Integer tickProgress = blackboard.getOrDefault(TICK_PROGRESS, 0);
        blackboard.set(COOLDOWN, currentCooldown);
        context.lookAt(EntityAnchorArgument.Anchor.EYES, target.getEyePosition());
        context.getLookControl().setLookAt((Entity)target);
        if (currentCooldown <= 0) {
            GunShootContext.create((LivingEntity)context, itemStack, tickProgress).map(GunShootContext::shoot).filter(result -> result == GunShootResult.SHOT).ifSome($ -> blackboard.set(COOLDOWN, fireMode.cooldownInTicks() * fireMode.consumedAmmunitionPerShot()));
        }
        blackboard.set(TICK_PROGRESS, tickProgress + 1);
    }
}

