/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.machine;

import com.avp.AVP;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.init.block.AVPBlocks;
import com.avp.common.registry.key.AVPDamageTypeKeys;
import com.avp.common.registry.tag.AVPDamageTypesTags;
import com.human.common.gameplay.block.entity.AmmoChestBlockEntity;
import com.human.common.gameplay.entity.machine.SentryTurretAnimDispatcher;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryTurret
extends Mob
implements TraceableEntity {
    public static float DAMAGE = AVP.config.blockConfigs.TURRET_DAMAGE;
    public static int RANGE = AVP.config.blockConfigs.TURRET_RANGE;
    protected static int AMMO_CHEST_RANGE = AVP.config.blockConfigs.TURRET_AMMO_CHEST_SEARCH_RANGE;
    protected static int FOV = AVP.config.blockConfigs.TURRET_FOV;
    private static final int MAX_TURRET_FIRE_COOLDOWN_IN_TICKS = 2;
    private static final String FIRE_COOLDOWN_KEY = "FireCooldown";
    private static final String OWNER_KEY = "Owner";
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private int fireCooldown = 0;
    protected final SentryTurretAnimDispatcher animDispatcher = new SentryTurretAnimDispatcher((Entity)this);

    public SentryTurret(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    public void setOwner(@Nullable Entity owner) {
        if (owner != null) {
            this.ownerUUID = owner.getUUID();
            this.cachedOwner = owner;
        }
    }

    @Nullable
    public Entity getOwner() {
        Level level;
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cachedOwner = serverLevel.getEntity(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public static AttributeSupplier.Builder createSentryTurretAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 100.0).add(Attributes.FOLLOW_RANGE, (double)RANGE);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            AmmoChestBlockEntity ammoChestBlockEntity;
            if (!this.isPoweredByRedstone()) {
                this.animDispatcher.unpowered();
                return;
            }
            if (this.getTarget() == null) {
                this.animDispatcher.idle();
            }
            if ((ammoChestBlockEntity = SentryTurret.findNearbyAmmoChest(this, this.blockPosition())) == null || !ammoChestBlockEntity.hasAmmo()) {
                this.setTarget(null);
                this.animDispatcher.idle();
                return;
            }
            if (this.getTarget() != null && !this.getTarget().isAlive()) {
                this.setTarget(null);
                this.animDispatcher.idle();
                return;
            }
            if (this.fireCooldown > 0) {
                --this.fireCooldown;
                return;
            }
            if (ammoChestBlockEntity.hasAmmo()) {
                this.targetAndFire(ammoChestBlockEntity);
            }
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID(OWNER_KEY)) {
            this.ownerUUID = compound.getUUID(OWNER_KEY);
            this.cachedOwner = null;
        }
        this.fireCooldown = compound.getInt(FIRE_COOLDOWN_KEY);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.putUUID(OWNER_KEY, this.ownerUUID);
        }
        compound.putInt(FIRE_COOLDOWN_KEY, this.fireCooldown);
    }

    @Nullable
    public ItemStack getPickResult() {
        return AVPBlocks.SENTRY_TURRET.get().asItem().getDefaultInstance();
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean canBeAffected(@NotNull MobEffectInstance effectInstance) {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(AVPDamageTypesTags.DOES_NOT_HURT_SENTRY_TURRETS)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.level().isClientSide && this.getOwner() != null && this.getOwner().is((Entity)player)) {
            this.dropTurretItem();
            this.discard();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    private void dropTurretItem() {
        ItemStack turretItem = this.getPickResult();
        if (turretItem != null) {
            this.spawnAtLocation(turretItem, 0.5f);
        }
    }

    private boolean isPoweredByRedstone() {
        return this.level().hasNeighborSignal(this.blockPosition());
    }

    private void targetAndFire(AmmoChestBlockEntity ammoChestBlockEntity) {
        LivingEntity target = this.getTarget();
        if (target != null && (!target.isAlive() || target.isRemoved())) {
            this.setTarget(null);
            this.fireCooldown = 0;
            this.animDispatcher.idle();
            return;
        }
        if (this.getTarget() == null) {
            this.findTarget();
        }
        if (this.getTarget() != null) {
            this.fireAtTarget(ammoChestBlockEntity);
        }
    }

    private void findTarget() {
        List monsters = this.level().getEntitiesOfClass(Monster.class, this.getBoundingBox().inflate((double)RANGE), this::canTargetMonster);
        if (!monsters.isEmpty()) {
            this.setTarget((LivingEntity)monsters.getFirst());
        }
    }

    private void fireAtTarget(AmmoChestBlockEntity ammoChestBlockEntity) {
        LivingEntity target = this.getTarget();
        if (target != null && target.isAlive() && SentryTurret.isFacingTarget(this.blockPosition(), this.getLookAngle(), target) && this.getSensing().hasLineOfSight((Entity)target)) {
            this.animDispatcher.firing();
            this.level().playSound(null, this.blockPosition(), AVPSoundEvents.WEAPON_GENERIC_SHOOT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            target.hurt(this.damageSources().source(AVPDamageTypeKeys.BULLET, (Entity)this), DAMAGE);
            target.setLastHurtMob((Entity)this);
            ammoChestBlockEntity.consumeAmmo(1);
            this.fireCooldown = 2;
            target.invulnerableTime = 0;
        } else {
            this.setTarget(null);
        }
    }

    private boolean canTargetMonster(Monster monster) {
        return monster.isAlive() && this.distanceTo((Entity)monster) <= (float)RANGE && SentryTurret.isFacingTarget(this.blockPosition(), this.getLookAngle(), (LivingEntity)monster) && this.getSensing().hasLineOfSight((Entity)monster);
    }

    private static boolean isFacingTarget(BlockPos turretPos, Vec3 facingVec, LivingEntity target) {
        Vec3 turretCenter = Vec3.atCenterOf((Vec3i)turretPos);
        Vec3 entityPos = Vec3.atCenterOf((Vec3i)target.blockPosition());
        Vec3 directionToEntity = entityPos.subtract(turretCenter).normalize();
        double dotProduct = directionToEntity.dot(facingVec.normalize());
        return dotProduct > Math.cos(Math.toRadians(FOV));
    }

    @Nullable
    private static AmmoChestBlockEntity findNearbyAmmoChest(SentryTurret sentryTurret, BlockPos pos) {
        Level level = sentryTurret.level();
        for (BlockPos searchRadius : BlockPos.betweenClosed((BlockPos)pos.offset(-AMMO_CHEST_RANGE, -AMMO_CHEST_RANGE, -AMMO_CHEST_RANGE), (BlockPos)pos.offset(AMMO_CHEST_RANGE, AMMO_CHEST_RANGE, AMMO_CHEST_RANGE))) {
            BlockEntity ammoEntity = level.getBlockEntity(searchRadius);
            if (!(ammoEntity instanceof AmmoChestBlockEntity)) continue;
            AmmoChestBlockEntity ammoChestBlockEntity = (AmmoChestBlockEntity)ammoEntity;
            return ammoChestBlockEntity;
        }
        return null;
    }
}

