/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.projectile;

import com.avp.AVP;
import com.human.common.registry.init.entity_type.HumanEntityTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Rocket
extends ThrowableProjectile {
    private static final String TICK_COUNT_KEY = "TickCount";

    public Rocket(EntityType<? extends Rocket> entityType, Level level) {
        super(entityType, level);
    }

    public Rocket(Level level, LivingEntity livingEntity) {
        super(HumanEntityTypes.ROCKET.get(), livingEntity, level);
    }

    public void tick() {
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        if (hitResult.getType() != HitResult.Type.MISS) {
            this.hitTargetOrDeflectSelf(hitResult);
        }
        this.checkInsideBlocks();
        Vec3 vec3 = this.getDeltaMovement();
        double d = this.getX() + vec3.x;
        double e = this.getY() + vec3.y;
        double f = this.getZ() + vec3.z;
        this.updateRotation();
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d - vec3.x * 0.25, e - vec3.y * 0.25, f - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
            }
        }
        this.setPos(d, e, f);
        if (this.tickCount >= 300) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        Level level = this.level();
        if (level.isClientSide) {
            double x = this.getX() + this.random.nextDouble() * (double)this.getBbWidth() * 0.5;
            double y = this.getZ() + this.random.nextDouble() * (double)this.getBbWidth() * 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, true, x, this.getY(0.8), y, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, true, x, this.getY(0.8), y, 0.0, 0.0, 0.0);
        }
    }

    protected void onHit(@NotNull HitResult hitResult) {
        Level.ExplosionInteraction explosionInteraction;
        super.onHit(hitResult);
        Level level = this.level();
        Level.ExplosionInteraction explosionInteraction2 = explosionInteraction = AVP.config.weaponConfigs.BULLETS_DAMAGE_BLOCKS_ENABLED ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE;
        if (!level.isClientSide) {
            level.explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), 5.0f, false, explosionInteraction);
            this.discard();
        }
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.tickCount = tag.getShort(TICK_COUNT_KEY);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort(TICK_COUNT_KEY, (short)this.tickCount);
    }
}

