/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item;

import com.human.common.gameplay.component.GeneReaderContents;
import com.human.common.gameplay.component.GeneReaderMode;
import com.human.common.registry.init.HumanDataComponents;
import com.lib.common.gameplay.entity.manager.GeneContainer;
import com.lib.common.gameplay.gene.Gene;
import com.lib.common.gameplay.gene.GeneBonusDataEntry;
import com.lib.common.gameplay.gene.GeneModifierKey;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.GeneRegistry;
import com.lib.common.model.GeneCarrier;
import com.lib.common.registry.GeneBonusDataRegistry;
import com.lib.common.util.GeneDataUtil;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GeneReaderItem
extends Item {
    private static final GeneReaderMode DEFAULT_MODE = GeneReaderMode.BONUS_GENES;

    public GeneReaderItem() {
        super(new Item.Properties().stacksTo(1).component(HumanDataComponents.GENE_READER_MODE.get(), (Object)DEFAULT_MODE).durability(1024));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        GeneReaderMode mode;
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                this.cycleGeneReaderMode(stack, player);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        if (!level.isClientSide && (mode = (GeneReaderMode)((Object)stack.getOrDefault(HumanDataComponents.GENE_READER_MODE.get(), (Object)DEFAULT_MODE))) == GeneReaderMode.CLEAR) {
            stack.set(HumanDataComponents.GENE_READER_CONTENTS.get(), (Object)GeneReaderContents.EMPTY);
            player.displayClientMessage((Component)Component.literal((String)"Gene data has been cleared."), true);
        }
        return super.use(level, player, hand);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        ItemStack stack;
        GeneReaderMode mode;
        Player player = context.getPlayer();
        if (player == null) {
            return super.useOn(context);
        }
        if (player.isShiftKeyDown()) {
            if (!context.getLevel().isClientSide()) {
                this.cycleGeneReaderMode(context.getItemInHand(), context.getPlayer());
            }
            return InteractionResult.SUCCESS;
        }
        if (!context.getLevel().isClientSide() && (mode = (GeneReaderMode)((Object)(stack = context.getItemInHand()).getOrDefault(HumanDataComponents.GENE_READER_MODE.get(), (Object)DEFAULT_MODE))) == GeneReaderMode.CLEAR) {
            stack.set(HumanDataComponents.GENE_READER_CONTENTS.get(), (Object)GeneReaderContents.EMPTY);
            player.displayClientMessage((Component)Component.literal((String)"Gene data has been cleared."), true);
        }
        return super.useOn(context);
    }

    private void cycleGeneReaderMode(ItemStack stack, Player player) {
        GeneReaderMode current = (GeneReaderMode)((Object)stack.getOrDefault(HumanDataComponents.GENE_READER_MODE.get(), (Object)DEFAULT_MODE));
        GeneReaderMode next = this.nextMode(current);
        stack.set(HumanDataComponents.GENE_READER_MODE.get(), (Object)next);
        player.displayClientMessage((Component)Component.literal((String)"Switched mode to ").append((Component)Component.literal((String)next.toString()).withStyle(ChatFormatting.YELLOW)), true);
    }

    private GeneReaderMode nextMode(GeneReaderMode current) {
        GeneReaderMode[] values = GeneReaderMode.values();
        int nextOrdinal = (current.ordinal() + 1) % values.length;
        return values[nextOrdinal];
    }

    public static void interact(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        GeneReaderMode geneReaderMode = (GeneReaderMode)((Object)stack.getOrDefault(HumanDataComponents.GENE_READER_MODE.get(), (Object)DEFAULT_MODE));
        if (geneReaderMode == GeneReaderMode.CLEAR) {
            return;
        }
        Map<GeneModifierKey, Double> geneBonusMapData = GeneBonusDataRegistry.getOrDefault(interactionTarget.getType());
        if (geneBonusMapData.isEmpty()) {
            return;
        }
        GeneContainer geneContainer = ((GeneCarrier)interactionTarget).getOrCreateGeneManager().getGeneContainer();
        EnumMap<GeneReaderMode, List<GeneBonusDataEntry>> geneReaderContents = new EnumMap<GeneReaderMode, List<GeneBonusDataEntry>>(GeneReaderMode.class);
        geneReaderContents.put(GeneReaderMode.ACTIVE_GENES, GeneDataUtil.toList(geneContainer.getActiveGeneMap().getBackingMap()));
        geneReaderContents.put(GeneReaderMode.DORMANT_GENES, GeneDataUtil.toList(geneContainer.getDormantGeneMap().getBackingMap()));
        geneReaderContents.put(GeneReaderMode.BONUS_GENES, GeneDataUtil.toList(geneBonusMapData));
        stack.set(HumanDataComponents.GENE_READER_CONTENTS.get(), (Object)new GeneReaderContents(geneReaderContents));
        stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
        player.setItemInHand(usedHand, stack);
        interactionTarget.hurt(interactionTarget.damageSources().generic(), 0.01f);
        player.displayClientMessage((Component)Component.literal((String)"Processed gene data from target."), true);
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        list.add((Component)Component.literal((String)"Shift + Right Click to change mode.").withStyle(ChatFormatting.GRAY));
        list.add(CommonComponents.EMPTY);
        GeneReaderMode geneReaderMode = (GeneReaderMode)((Object)itemStack.getOrDefault(HumanDataComponents.GENE_READER_MODE.get(), (Object)DEFAULT_MODE));
        list.add((Component)Component.literal((String)"Current Mode: ").append((Component)Component.literal((String)geneReaderMode.toString()).withStyle(ChatFormatting.YELLOW)));
        GeneReaderContents geneReaderContents = (GeneReaderContents)itemStack.getOrDefault(HumanDataComponents.GENE_READER_CONTENTS.get(), (Object)GeneReaderContents.EMPTY);
        if (geneReaderContents.equals(GeneReaderContents.EMPTY) || geneReaderMode == GeneReaderMode.CLEAR) {
            return;
        }
        List geneEntries = geneReaderContents.geneBonusDataEntriesByMode().getOrDefault((Object)geneReaderMode, List.of());
        list.add(CommonComponents.EMPTY);
        list.add((Component)Component.literal((String)"Genes:").withStyle(ChatFormatting.YELLOW));
        if (geneEntries.isEmpty()) {
            list.add((Component)Component.literal((String)"No gene data found.").withStyle(ChatFormatting.GRAY));
        } else {
            geneEntries.stream().filter(entry -> GeneRegistry.getValue(entry.id()).isSome()).forEach(entry -> list.add((Component)Component.translatable((String)((Gene)GeneRegistry.getValue(entry.id()).unwrap()).getTranslationKey()).append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)this.format(entry.operation(), entry.value())).withStyle(this.getColorForValue(entry.value())))));
        }
    }

    private String format(GeneOperationType operation, double value) {
        String suffix = operation == GeneOperationType.MULTIPLICATIVE ? "%" : "";
        String sign = value > 0.0 ? "+" : "";
        String formattedValue = String.format("%.2f", operation == GeneOperationType.MULTIPLICATIVE ? value * 100.0 : value);
        return sign + formattedValue + suffix;
    }

    private ChatFormatting getColorForValue(double value) {
        if (value > 0.0) {
            return ChatFormatting.GREEN;
        }
        if (value < 0.0) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.GRAY;
    }
}

