/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item;

import com.human.common.gameplay.component.SyringeContents;
import com.human.common.gameplay.component.SyringeMode;
import com.human.common.registry.init.HumanDataComponents;
import com.lib.common.gameplay.gene.GeneBonusDataEntry;
import com.lib.common.gameplay.gene.GeneModifierKey;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.Genes;
import com.lib.common.model.GeneCarrier;
import com.lib.common.registry.GeneBonusDataRegistry;
import com.lib.common.util.GeneDataUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SyringeItem
extends Item {
    private static final SyringeMode DEFAULT_SYRINGE_MODE = SyringeMode.EXTRACT;

    public SyringeItem() {
        super(new Item.Properties().stacksTo(1).component(HumanDataComponents.SYRINGE_MODE.get(), (Object)DEFAULT_SYRINGE_MODE).durability(20));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        SyringeMode mode;
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                this.cycleSyringeMode(stack, player);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        if (!level.isClientSide && (mode = (SyringeMode)((Object)stack.getOrDefault(HumanDataComponents.SYRINGE_MODE.get(), (Object)DEFAULT_SYRINGE_MODE))) == SyringeMode.EMPTY) {
            stack.set(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)SyringeContents.EMPTY);
            player.displayClientMessage((Component)Component.literal((String)"Syringe has been emptied."), true);
        }
        return super.use(level, player, hand);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        ItemStack stack;
        SyringeMode mode;
        Player player = context.getPlayer();
        if (player == null) {
            return super.useOn(context);
        }
        if (player.isShiftKeyDown()) {
            if (!context.getLevel().isClientSide()) {
                this.cycleSyringeMode(context.getItemInHand(), context.getPlayer());
            }
            return InteractionResult.SUCCESS;
        }
        if (!context.getLevel().isClientSide() && (mode = (SyringeMode)((Object)(stack = context.getItemInHand()).getOrDefault(HumanDataComponents.SYRINGE_MODE.get(), (Object)DEFAULT_SYRINGE_MODE))) == SyringeMode.EMPTY) {
            stack.set(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)SyringeContents.EMPTY);
            player.displayClientMessage((Component)Component.literal((String)"Syringe has been emptied."), true);
        }
        return super.useOn(context);
    }

    private void cycleSyringeMode(ItemStack stack, Player player) {
        SyringeMode current = (SyringeMode)((Object)stack.getOrDefault(HumanDataComponents.SYRINGE_MODE.get(), (Object)DEFAULT_SYRINGE_MODE));
        SyringeMode next = this.nextMode(current);
        stack.set(HumanDataComponents.SYRINGE_MODE.get(), (Object)next);
        player.displayClientMessage((Component)Component.literal((String)"Switched mode to ").append((Component)Component.literal((String)next.toString()).withStyle(ChatFormatting.YELLOW)), true);
    }

    private SyringeMode nextMode(SyringeMode current) {
        SyringeMode[] values = SyringeMode.values();
        int nextOrdinal = (current.ordinal() + 1) % values.length;
        return values[nextOrdinal];
    }

    public static void interact(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        SyringeContents syringeContents = (SyringeContents)stack.getOrDefault(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)SyringeContents.EMPTY);
        SyringeMode syringeMode = (SyringeMode)((Object)stack.getOrDefault(HumanDataComponents.SYRINGE_MODE.get(), (Object)DEFAULT_SYRINGE_MODE));
        switch (syringeMode) {
            case EMPTY: {
                stack.set(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)SyringeContents.EMPTY);
                player.setItemInHand(usedHand, stack);
                break;
            }
            case EXTRACT: {
                Map<GeneModifierKey, Double> geneBonusMapData = GeneBonusDataRegistry.getOrDefault(interactionTarget.getType());
                if (geneBonusMapData.isEmpty()) {
                    return;
                }
                HashMap<GeneModifierKey, Double> currentGeneBonusMap = new HashMap<GeneModifierKey, Double>(GeneDataUtil.toMap(syringeContents.geneBonusDataEntries()));
                currentGeneBonusMap.putAll(geneBonusMapData);
                List<GeneBonusDataEntry> geneBonusDataEntries = currentGeneBonusMap.entrySet().stream().map(entry -> new GeneBonusDataEntry(((GeneModifierKey)entry.getKey()).resourceLocation(), ((GeneModifierKey)entry.getKey()).operation(), (Double)entry.getValue())).toList();
                stack.set(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)new SyringeContents(geneBonusDataEntries));
                stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
                player.setItemInHand(usedHand, stack);
                interactionTarget.hurt(interactionTarget.damageSources().generic(), 0.01f);
                player.displayClientMessage((Component)Component.literal((String)"Extracted genes from target."), true);
                break;
            }
            case INJECT: {
                GeneCarrier geneCarrier = (GeneCarrier)interactionTarget;
                geneCarrier.getOrCreateGeneManager().getGeneContainer().getDormantGeneMap().putAll(GeneDataUtil.toMap(syringeContents.geneBonusDataEntries()));
                ResourceLocation resourceLocation = Genes.GENETIC_INTEGRITY.get().id();
                geneCarrier.getOrCreateGeneManager().getGeneContainer().getDormantGeneMap().add(resourceLocation, GeneOperationType.ADDITIVE, -0.34);
                stack.set(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)SyringeContents.EMPTY);
                stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
                player.setItemInHand(usedHand, stack);
                interactionTarget.hurt(interactionTarget.damageSources().generic(), 0.01f);
                player.displayClientMessage((Component)Component.literal((String)"Injected target with genes."), true);
            }
        }
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        list.add((Component)Component.literal((String)"Shift + Right Click to change mode.").withStyle(ChatFormatting.GRAY));
        list.add(CommonComponents.EMPTY);
        SyringeMode mode = (SyringeMode)((Object)itemStack.getOrDefault(HumanDataComponents.SYRINGE_MODE.get(), (Object)DEFAULT_SYRINGE_MODE));
        list.add((Component)Component.literal((String)"Current Mode: ").append((Component)Component.literal((String)mode.toString()).withStyle(ChatFormatting.YELLOW)));
        SyringeContents syringeContents = (SyringeContents)itemStack.getOrDefault(HumanDataComponents.SYRINGE_CONTENTS.get(), (Object)SyringeContents.EMPTY);
        if (syringeContents.equals(SyringeContents.EMPTY) || syringeContents.geneBonusDataEntries().isEmpty()) {
            return;
        }
        list.add(CommonComponents.EMPTY);
        list.add((Component)Component.literal((String)"Genes:").withStyle(ChatFormatting.YELLOW));
        list.add((Component)Component.literal((String)"???").withStyle(ChatFormatting.GRAY));
    }
}

