/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun.attack.hitscan;

import com.avp.AVP;
import com.avp.common.network.packet.S2CBulletHitBlockPayload;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.tag.AVPBlockTags;
import com.avp.server.BlockBreakProgressManager;
import com.avp.service.Services;
import com.human.common.gameplay.item.gun.attack.GunAttackConfig;
import com.human.common.gameplay.item.gun.attack.GunHitResult;
import com.lib.common.gameplay.util.EnchantmentUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockGunHitResultHandler {
    public static void handle(GunAttackConfig gunAttackConfig, GunHitResult.Block gunHitResult) {
        BlockPos blockPos = gunHitResult.blockPos();
        Direction direction = gunHitResult.direction();
        Level level = gunAttackConfig.shooter().level();
        BlockState blockState = level.getBlockState(blockPos);
        SoundType soundType = blockState.getSoundType();
        SoundEvent ricochetSoundEvent = BlockGunHitResultHandler.getRicochetSoundForSoundType(soundType);
        level.playSound(null, blockPos, ricochetSoundEvent, SoundSource.BLOCKS);
        BlockGunHitResultHandler.damageBlock(gunAttackConfig, level, blockPos, blockState);
        S2CBulletHitBlockPayload payload = new S2CBulletHitBlockPayload(blockPos, direction);
        Services.SERVER_NETWORKING.sendToAllClients(level.getServer(), payload);
    }

    private static SoundEvent getRicochetSoundForSoundType(SoundType soundType) {
        SoundEvent ricochetSfx = soundType == SoundType.GLASS ? AVPSoundEvents.WEAPON_FX_RICOCHET_GLASS.get() : (soundType == SoundType.GRAVEL ? AVPSoundEvents.WEAPON_FX_RICOCHET_DIRT.get() : (soundType == SoundType.METAL ? AVPSoundEvents.WEAPON_FX_RICOCHET_METAL.get() : AVPSoundEvents.WEAPON_FX_RICOCHET_GENERIC.get()));
        return ricochetSfx;
    }

    private static void damageBlock(GunAttackConfig gunAttackConfig, Level level, BlockPos blockPos, BlockState blockState) {
        Player player;
        LivingEntity livingEntity;
        if (!AVP.config.weaponConfigs.BULLETS_DAMAGE_BLOCKS_ENABLED || !level.getGameRules().getBoolean(GameRules.RULE_PROJECTILESCANBREAKBLOCKS) || blockState.is(AVPBlockTags.SHOULD_NOT_BE_DESTROYED) || (livingEntity = gunAttackConfig.shooter()) instanceof Player && !Services.EVENT.beforeBlockBreak(level, blockPos, blockState, player = (Player)livingEntity)) {
            return;
        }
        int powerLevel = EnchantmentUtil.getLevel(level, gunAttackConfig.gunItemStack(), (ResourceKey<Enchantment>)Enchantments.POWER);
        float damage = gunAttackConfig.fireModeConfig().damage() * (1.0f + 0.25f * (float)powerLevel);
        BlockBreakProgressManager.damage(level, blockPos, damage);
    }
}

