/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun.pipeline.step.impl;

import com.human.common.gameplay.item.GunItem;
import com.human.common.gameplay.item.gun.GunConfig;
import com.human.common.gameplay.item.gun.GunReloading;
import com.human.common.gameplay.item.gun.pipeline.GunShootContext;
import com.human.common.gameplay.item.gun.pipeline.GunShootResult;
import com.human.common.gameplay.item.gun.pipeline.step.GunShootStep;
import com.human.common.registry.init.item.HumanGunItems;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CheckReloadingStep
implements GunShootStep {
    public static final CheckReloadingStep INSTANCE = new CheckReloadingStep();

    private CheckReloadingStep() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GunShootResult apply(GunShootContext context) {
        int currentAmmunition = context.currentAmmunition();
        GunConfig gunConfig = context.gunConfig();
        GunItem gunItem = context.gunItem();
        boolean hasInfinity = context.hasInfinity();
        boolean isShooterImmortal = context.isShooterImmortal();
        LivingEntity shooter = context.shooter();
        Level level = shooter.level();
        Supplier<ItemLike> supplier = gunConfig.ammunitionItemSupplier();
        if (!(shooter instanceof Player)) return GunShootResult.CONTINUE;
        Player player = (Player)shooter;
        if (isShooterImmortal || hasInfinity) {
            return GunShootResult.CONTINUE;
        }
        if (gunItem == HumanGunItems.OLD_PAINLESS.get() && supplier != null) {
            int amountToConsume;
            ItemLike ammunitionItem = supplier.get();
            GunReloading.ItemConsumptionResult itemConsumptionResult = GunReloading.consumeItemAmountFromInventory(player, ammunitionItem, amountToConsume = gunConfig.getDefaultFireMode().consumedAmmunitionPerShot(), false);
            if (itemConsumptionResult != GunReloading.ItemConsumptionResult.Full.INSTANCE) return GunShootResult.FAILURE;
            if (level.isClientSide) return GunShootResult.CONTINUE;
            GunReloading.consumeItemAmountFromInventory(player, ammunitionItem, amountToConsume, true);
            return GunShootResult.CONTINUE;
        } else {
            if (currentAmmunition > 0) return GunShootResult.CONTINUE;
            if (level.isClientSide) return GunShootResult.RELOADING;
            GunReloading.reload(player);
            return GunShootResult.RELOADING;
        }
    }
}

