/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.util;

public class ColorUtil {
    public static int hslToRgbInt(float h, float s, float l) {
        float r;
        float g;
        float b;
        h /= 360.0f;
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = ColorUtil.hueToRgb(p, q, h + 0.33333334f);
            g = ColorUtil.hueToRgb(p, q, h);
            b = ColorUtil.hueToRgb(p, q, h - 0.33333334f);
        }
        int red = Math.round(r * 255.0f);
        int green = Math.round(g * 255.0f);
        int blue = Math.round(b * 255.0f);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    private static float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }
}

