/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.ai.action;

import com.just.core.functional.option.Option;
import com.lib.common.gameplay.goap.GOAPAction;
import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.condition.expression.GOAPExpression;
import com.lib.common.gameplay.goap.effect.GOAPEffect;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class MoveToTargetEntityAction<T extends Mob, E extends Entity>
extends GOAPAction<T> {
    private final BiPredicate<GOAPWorldState, Double> distanceSqrIsInRangePredicate;
    private final TypedIdentifier<Option<? extends E>> nearestTargetIdentifier;
    private final double speedMultiplier;

    public MoveToTargetEntityAction(TypedIdentifier<Option<? extends E>> nearestTargetIdentifier, TypedIdentifier<Boolean> isInRangeIdentifier, double speedMultiplier, BiPredicate<GOAPWorldState, Double> distanceSqrIsInRangePredicate) {
        this.distanceSqrIsInRangePredicate = distanceSqrIsInRangePredicate;
        this.nearestTargetIdentifier = nearestTargetIdentifier;
        this.speedMultiplier = speedMultiplier;
        this.addPrecondition(nearestTargetIdentifier, GOAPExpression.isSome());
        this.addPrecondition(isInRangeIdentifier, GOAPExpression.isFalse());
        this.addEffect(new GOAPEffect.Value<Boolean>(isInRangeIdentifier, true));
    }

    @Override
    public boolean perform(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        Option targetEntityOption = (Option)worldState.getOrDefault(this.nearestTargetIdentifier, Option.none());
        if (targetEntityOption.isNone()) {
            return true;
        }
        Entity target = (Entity)targetEntityOption.unwrap();
        if (this.distanceSqrIsInRangePredicate.test(worldState, context.distanceToSqr(target))) {
            return true;
        }
        BlockPos targetPos = target.blockPosition().below();
        BlockState state = context.level().getBlockState(targetPos);
        if (state.entityCanStandOn((BlockGetter)context.level(), targetPos, context)) {
            context.getNavigation().moveTo(target, this.speedMultiplier);
        }
        return false;
    }

    @Override
    public void onFinish(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        context.getNavigation().stop();
    }

    @Override
    public float getCost(T context, GOAPWorldState worldState) {
        return ((Float)((Option)worldState.getOrDefault(this.nearestTargetIdentifier, Option.none())).match(target -> {
            float distSqr = (float)context.distanceToSqr(target);
            AttributeInstance attribute = context.getAttribute(Attributes.FOLLOW_RANGE);
            float maxDistance = attribute == null ? 16.0f : (float)attribute.getValue();
            return Float.valueOf(Math.clamp(distSqr / (maxDistance * maxDistance), 0.0f, 1.0f));
        }, () -> Float.valueOf(1.0f))).floatValue();
    }
}

