/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.gene;

import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.avp.AVPResources;
import com.avp.common.registry.AVPDeferredHolder;
import com.just.core.functional.function.Function2;
import com.lib.common.gameplay.entity.manager.GeneContainer;
import com.lib.common.gameplay.gene.Gene;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.GeneRegistry;
import com.lib.common.model.GeneCarrier;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class Genes {
    public static final AVPDeferredHolder<Gene> ACID_RESISTANCE = Genes.registerSimple("acid_resistance", (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> switch (geneOperationType) {
        default -> throw new MatchException(null, null);
        case GeneOperationType.ADDITIVE -> Math.clamp(value, -100.0, 100.0);
        case GeneOperationType.MULTIPLICATIVE -> Math.clamp(value, -1.0, 1.0);
    }));
    public static final AVPDeferredHolder<Gene> ACID_VOLATILITY = Genes.registerSimple("acid_volatility", (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> switch (geneOperationType) {
        default -> throw new MatchException(null, null);
        case GeneOperationType.ADDITIVE -> Math.clamp(value, 0.0, 100.0);
        case GeneOperationType.MULTIPLICATIVE -> Math.clamp(value, 0.0, 1.0);
    }));
    public static final AVPDeferredHolder<Gene> ACIDIC_BLOOD = Genes.registerSimple("acidic_blood", (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> {
        switch (geneOperationType) {
            default: {
                throw new MatchException(null, null);
            }
            case ADDITIVE: 
            case MULTIPLICATIVE: 
        }
        return value;
    }));
    public static final AVPDeferredHolder<Gene> ARMOR = Genes.registerAttribute("armor", (Holder<Attribute>)Attributes.ARMOR, (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> switch (geneOperationType) {
        default -> throw new MatchException(null, null);
        case GeneOperationType.ADDITIVE -> Math.clamp(value, 0.0, 24.0);
        case GeneOperationType.MULTIPLICATIVE -> Math.clamp(value, -1.0, 3.0);
    }));
    public static final AVPDeferredHolder<Gene> ARMOR_TOUGHNESS = Genes.registerAttribute("armor_toughness", (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> switch (geneOperationType) {
        default -> throw new MatchException(null, null);
        case GeneOperationType.ADDITIVE -> Math.clamp(value, 0.0, 24.0);
        case GeneOperationType.MULTIPLICATIVE -> Math.clamp(value, -1.0, 3.0);
    }));
    public static final AVPDeferredHolder<Gene> ATTACK_DAMAGE = Genes.registerAttribute("attack_damage", (Holder<Attribute>)Attributes.ATTACK_DAMAGE, (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> switch (geneOperationType) {
        default -> throw new MatchException(null, null);
        case GeneOperationType.ADDITIVE -> Math.clamp(value, -50.0, 50.0);
        case GeneOperationType.MULTIPLICATIVE -> Math.clamp(value, -0.9, 3.0);
    }));
    public static final AVPDeferredHolder<Gene> BONUS_EMBRYO_COUNT = Genes.registerSimple("bonus_embryo_count", (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> {
        switch (geneOperationType) {
            default: {
                throw new MatchException(null, null);
            }
            case ADDITIVE: 
            case MULTIPLICATIVE: 
        }
        return Math.clamp(value, 0.0, 3.0);
    }));
    public static final AVPDeferredHolder<Gene> BONUS_PARASITE_COUNT = Genes.registerEffect("bonus_parasite_count", Genes::handleBonusParasiteCount, (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> {
        switch (geneOperationType) {
            default: {
                throw new MatchException(null, null);
            }
            case ADDITIVE: 
            case MULTIPLICATIVE: 
        }
        return Math.clamp(value, 0.0, 3.0);
    }));
    public static final AVPDeferredHolder<Gene> COLD_RESISTANCE = Genes.registerSimple("cold_resistance", (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> switch (geneOperationType) {
        default -> throw new MatchException(null, null);
        case GeneOperationType.ADDITIVE -> Math.clamp(value, -100.0, 100.0);
        case GeneOperationType.MULTIPLICATIVE -> Math.clamp(value, -1.0, 1.0);
    }));
    public static final AVPDeferredHolder<Gene> FIRE_RESISTANCE = Genes.registerSimple("fire_resistance", (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> switch (geneOperationType) {
        default -> throw new MatchException(null, null);
        case GeneOperationType.ADDITIVE -> Math.clamp(value, -100.0, 100.0);
        case GeneOperationType.MULTIPLICATIVE -> Math.clamp(value, -1.0, 1.0);
    }));
    public static final AVPDeferredHolder<Gene> GENETIC_INTEGRITY = Genes.registerSimple("genetic_integrity", (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> switch (geneOperationType) {
        default -> throw new MatchException(null, null);
        case GeneOperationType.ADDITIVE -> Math.clamp(value, -300.0, 100.0);
        case GeneOperationType.MULTIPLICATIVE -> Math.clamp(value, -3.0, 3.0);
    }));
    public static final AVPDeferredHolder<Gene> INTELLIGENCE = Genes.registerSimple("intelligence", (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> switch (geneOperationType) {
        default -> throw new MatchException(null, null);
        case GeneOperationType.ADDITIVE -> Math.clamp(value, -100.0, 100.0);
        case GeneOperationType.MULTIPLICATIVE -> Math.clamp(value, -1.0, 1.0);
    }));
    public static final AVPDeferredHolder<Gene> KNOCKBACK_RESISTANCE = Genes.registerAttribute("knockback_resistance", (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> switch (geneOperationType) {
        default -> throw new MatchException(null, null);
        case GeneOperationType.ADDITIVE -> Math.clamp(value, 0.0, 1.0);
        case GeneOperationType.MULTIPLICATIVE -> Math.clamp(value, -1.0, 3.0);
    }));
    public static final AVPDeferredHolder<Gene> MAX_HEALTH = Genes.registerAttribute("max_health", (Holder<Attribute>)Attributes.MAX_HEALTH, (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> switch (geneOperationType) {
        default -> throw new MatchException(null, null);
        case GeneOperationType.ADDITIVE -> Math.clamp(value, 0.0, 200.0);
        case GeneOperationType.MULTIPLICATIVE -> Math.clamp(value, -0.9, 3.0);
    }));
    public static final AVPDeferredHolder<Gene> MOVE_SPEED = Genes.registerAttribute("move_speed", (Holder<Attribute>)Attributes.MOVEMENT_SPEED, (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> switch (geneOperationType) {
        default -> throw new MatchException(null, null);
        case GeneOperationType.ADDITIVE -> Math.clamp(value, 0.0, 0.6);
        case GeneOperationType.MULTIPLICATIVE -> Math.clamp(value, -0.9, 2.0);
    }));
    public static final AVPDeferredHolder<Gene> POISON = Genes.registerSimple("poison", (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> {
        switch (geneOperationType) {
            default: {
                throw new MatchException(null, null);
            }
            case ADDITIVE: 
            case MULTIPLICATIVE: 
        }
        return value;
    }));
    public static final AVPDeferredHolder<Gene> POISONOUS_BARBS = Genes.registerSimple("poisonous_barbs", (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> {
        switch (geneOperationType) {
            default: {
                throw new MatchException(null, null);
            }
            case ADDITIVE: 
            case MULTIPLICATIVE: 
        }
        return value;
    }));
    public static final AVPDeferredHolder<Gene> THORNS = Genes.registerSimple("thorns", (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> {
        switch (geneOperationType) {
            default: {
                throw new MatchException(null, null);
            }
            case ADDITIVE: 
            case MULTIPLICATIVE: 
        }
        return value;
    }));
    public static final AVPDeferredHolder<Gene> WARP = Genes.registerSimple("warp", (Function2<Double, GeneOperationType, Double>)((Function2)(value, geneOperationType) -> {
        switch (geneOperationType) {
            default: {
                throw new MatchException(null, null);
            }
            case ADDITIVE: 
            case MULTIPLICATIVE: 
        }
        return Math.clamp(value, 0.0, 1.0);
    }));

    public static void initialize() {
    }

    private static AVPDeferredHolder<Gene> registerAttribute(String name, Holder<Attribute> attribute, Function2<Double, GeneOperationType, Double> transformer) {
        return GeneRegistry.register(() -> new Gene.Attribute(AVPResources.location(name), attribute, transformer));
    }

    private static AVPDeferredHolder<Gene> registerEffect(String name, Consumer<LivingEntity> onChange, Function2<Double, GeneOperationType, Double> transformer) {
        return GeneRegistry.register(() -> new Gene.Effect(AVPResources.location(name), onChange, transformer));
    }

    private static AVPDeferredHolder<Gene> registerSimple(String name, Function2<Double, GeneOperationType, Double> transformer) {
        return GeneRegistry.register(() -> new Gene.Simple(AVPResources.location(name), transformer));
    }

    private static void handleBonusParasiteCount(LivingEntity entity) {
        if (!(entity instanceof Ovomorph)) {
            return;
        }
        Ovomorph ovomorph = (Ovomorph)entity;
        AttributeInstance scaleAttribute = ovomorph.getAttribute(Attributes.SCALE);
        if (scaleAttribute != null) {
            GeneContainer geneContainer = ((GeneCarrier)((Object)ovomorph)).getOrCreateGeneManager().getGeneContainer();
            double totalParasiteCount = geneContainer.getActiveGeneMap().getValue(BONUS_PARASITE_COUNT);
            AttributeModifier modifier = new AttributeModifier(BONUS_PARASITE_COUNT.get().id(), totalParasiteCount / 2.0, AttributeModifier.Operation.ADD_VALUE);
            ovomorph.maxSpawnCount.set((byte)(1.0 + totalParasiteCount));
            scaleAttribute.addOrReplacePermanentModifier(modifier);
        }
    }
}

