/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.goap;

import com.just.core.functional.option.Option;
import com.lib.common.gameplay.goap.GOAPAction;
import com.lib.common.gameplay.goap.GOAPGoal;
import com.lib.common.gameplay.goap.GOAPSensor;
import com.lib.common.gameplay.goap.plan.GOAPPlan;
import com.lib.common.gameplay.goap.plan.GOAPPlanner;
import com.lib.common.gameplay.goap.state.GOAPMutableWorldState;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class GOAP<T> {
    private final Set<GOAPAction<T>> actions;
    private final Set<GOAPGoal> goals;
    private final GOAPPlanner<T> planner = new GOAPPlanner(this);
    private final List<GOAPSensor<? super T>> sensors;
    @NotNull
    private Option<GOAPPlan<T>> currentPlanOption;
    private boolean isEnabled = true;

    protected GOAP() {
        this.actions = new HashSet<GOAPAction<T>>();
        this.goals = new HashSet<GOAPGoal>();
        this.sensors = new ArrayList<GOAPSensor<? super T>>();
        this.currentPlanOption = Option.none();
    }

    public void addAction(GOAPAction<T> action) {
        this.actions.add(action);
    }

    public void addGoal(GOAPGoal goal) {
        this.goals.add(goal);
    }

    public void addSensor(GOAPSensor<? super T> sensor) {
        this.sensors.add(sensor);
    }

    public GOAPWorldState sense(T context) {
        GOAPMutableWorldState state = new GOAPMutableWorldState();
        for (GOAPSensor<T> sensor : this.sensors) {
            sensor.sense(context, state);
        }
        return state;
    }

    public void update(T context) {
        if (!this.isEnabled) {
            return;
        }
        GOAPWorldState worldState = this.sense(context);
        if (this.currentPlanOption.isNone()) {
            this.currentPlanOption = this.planner.createPlan(context, worldState, this.goals);
        }
        this.currentPlanOption.ifSome(plan -> {
            GOAPPlan.State planState;
            GOAPPlan.State state = planState = plan.update(context, worldState);
            Objects.requireNonNull(state);
            GOAPPlan.State selector0$temp = state;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GOAPPlan.State.Failed.class, GOAPPlan.State.Finished.class, GOAPPlan.State.Invalid.class, GOAPPlan.State.InProgress.class}, (Object)selector0$temp, index$1)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    GOAPPlan.State.Failed failed = (GOAPPlan.State.Failed)selector0$temp;
                    this.currentPlanOption = Option.none();
                    break;
                }
                case 1: {
                    GOAPPlan.State.Finished finished = (GOAPPlan.State.Finished)selector0$temp;
                    this.currentPlanOption = Option.none();
                    break;
                }
                case 2: {
                    GOAPPlan.State.Invalid invalid = (GOAPPlan.State.Invalid)selector0$temp;
                    this.currentPlanOption = Option.none();
                    break;
                }
                case 3: {
                    GOAPPlan.State.InProgress inProgress = (GOAPPlan.State.InProgress)selector0$temp;
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public Collection<GOAPAction<T>> getAvailableActions() {
        return this.actions;
    }
}

