/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.network;

import com.just.codec.stream.StreamCodec;
import com.just.codec.stream.schema.StreamCodecSchema;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public record RawDataSyncMap(Map<Integer, byte[]> rawDataById) {
    public static final StreamCodec<RawDataSyncMap> STREAM_CODEC = new StreamCodec<RawDataSyncMap>(){

        public <T> void encode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input, @NotNull RawDataSyncMap value) {
            streamCodecSchema.writeVarInt(input, value.rawDataById.size());
            for (Map.Entry<Integer, byte[]> entry : value.rawDataById.entrySet()) {
                streamCodecSchema.writeByte(input, entry.getKey().byteValue());
                streamCodecSchema.writeByte(input, (byte)entry.getValue().length);
                streamCodecSchema.writeBytes(input, entry.getValue());
            }
        }

        @NotNull
        public <T> RawDataSyncMap decode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input) {
            HashMap<Integer, byte[]> rawDataById = new HashMap<Integer, byte[]>();
            int length = streamCodecSchema.readVarInt(input);
            for (int i = 0; i < length; ++i) {
                byte id = streamCodecSchema.readByte(input);
                byte dataLength = streamCodecSchema.readByte(input);
                byte[] data = streamCodecSchema.readBytes(input, (int)dataLength);
                rawDataById.put(Integer.valueOf(id), data);
            }
            return new RawDataSyncMap(rawDataById);
        }
    };
}

