/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.util;

import com.lib.common.gameplay.entity.manager.GeneContainer;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.Genes;
import com.lib.common.model.GeneCarrier;
import com.lib.common.model.GeneDecayLevelType;

public class GeneIntegrityUtil {
    public static GeneDecayLevelType getGeneDecayLevel(GeneCarrier geneCarrier) {
        double totalGeneticIntegrity = GeneIntegrityUtil.getTotalGeneticIntegrity(geneCarrier);
        if (totalGeneticIntegrity < (double)(-GeneDecayLevelType.FATAL.getMagnitude())) {
            return GeneDecayLevelType.FATAL;
        }
        if (totalGeneticIntegrity < (double)(-GeneDecayLevelType.VOLATILE.getMagnitude())) {
            return GeneDecayLevelType.VOLATILE;
        }
        if (totalGeneticIntegrity < (double)(-GeneDecayLevelType.UNSTABLE.getMagnitude())) {
            return GeneDecayLevelType.UNSTABLE;
        }
        return GeneDecayLevelType.STABLE;
    }

    public static double getTotalGeneticIntegrity(GeneCarrier geneCarrier) {
        GeneContainer geneContainer = geneCarrier.getOrCreateGeneManager().getGeneContainer();
        double additiveGeneticIntegrity = geneContainer.getActiveGeneMap().getValue(Genes.GENETIC_INTEGRITY, GeneOperationType.ADDITIVE);
        double multiplicativeGeneticIntegrity = geneContainer.getActiveGeneMap().getValue(Genes.GENETIC_INTEGRITY, GeneOperationType.MULTIPLICATIVE);
        return additiveGeneticIntegrity + multiplicativeGeneticIntegrity;
    }
}

