/*
 * Decompiled with CFR 0.152.
 */
package com.predator.common.gameplay.block;

import com.avp.common.registry.init.AVPBlockEntityTypes;
import com.mojang.serialization.MapCodec;
import com.predator.common.gameplay.block.entity.TripMineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TripMineBlock
extends BaseEntityBlock {
    public static final MapCodec<TripMineBlock> CODEC = TripMineBlock.simpleCodec(TripMineBlock::new);

    public TripMineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TripMineBlockEntity(blockPos, blockState);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.2, (double)11.0);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return TripMineBlock.createServerTicker(level, blockEntityType);
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createServerTicker(Level level, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : TripMineBlock.createTickerHelper(blockEntityType, AVPBlockEntityTypes.TRIP_MINE.get(), TripMineBlockEntity::serverTick);
    }

    public boolean dropFromExplosion(@NotNull Explosion explosion) {
        return false;
    }
}

