/*
 * Decompiled with CFR 0.152.
 */
package com.predator.common.gameplay.entity.living.yautja;

import com.avp.common.util.AVPPredicates;
import com.predator.common.gameplay.entity.living.yautja.Yautja;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.entity.EntityTypeTest;

public class YautjaSpawning {
    private static final int MIN_Y_LEVEL = 62;
    private static final int MINIMUM_DISTANCE_BETWEEN_YAUTJA_IN_BLOCKS = 512;
    public static final SpawnPlacements.SpawnPredicate<Yautja> PREDICATE = (entityType, serverLevelAccessor, mobSpawnType, blockPos, randomSource) -> blockPos.getY() >= 62 && YautjaSpawning.checkSpawnRules((EntityType<? extends Monster>)entityType, serverLevelAccessor, mobSpawnType, blockPos, randomSource);

    public static boolean checkSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return serverLevelAccessor.getDifficulty() != Difficulty.PEACEFUL && Mob.checkMobSpawnRules(entityType, (LevelAccessor)serverLevelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource) && !YautjaSpawning.anyNearbyYautja(serverLevelAccessor, blockPos, 512);
    }

    public static boolean anyNearbyYautja(ServerLevelAccessor serverLevelAccessor, BlockPos blockPos, int requiredDistanceInBlocks) {
        List allYautja = serverLevelAccessor.getLevel().getEntities(EntityTypeTest.forClass(Yautja.class), AVPPredicates.alwaysTrue());
        int requiredDistanceSquared = requiredDistanceInBlocks * requiredDistanceInBlocks;
        return allYautja.stream().anyMatch(yautja -> yautja.distanceToSqr(blockPos.getX(), blockPos.getY(), blockPos.getZ()) < (double)requiredDistanceSquared);
    }
}

