/*
 * Decompiled with CFR 0.152.
 */
package com.alien.client.animation.entity;

import com.avp.AVPResources;
import com.avp.client.animation.BasicAnimationUtils;
import com.predator.common.gameplay.entity.living.yautja.Yautja;
import mod.azure.azurelib.rewrite.animation.AzAnimationContext;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorConfig;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelib.rewrite.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class YautjaAnimator
extends AzEntityAnimator<Yautja> {
    private static final String NAME = "yautja";
    private static final ResourceLocation ANIMATION = AVPResources.entityAnimationLocation("yautja");

    public YautjaAnimator() {
        super(AzAnimatorConfig.defaultConfig());
    }

    public void registerControllers(AzAnimationControllerContainer<Yautja> animationControllerContainer) {
        animationControllerContainer.add(AzAnimationController.builder((AzAnimator)this, (String)"full_body").setTransitionLength(5).build(), new AzAnimationController[0]);
    }

    @NotNull
    public ResourceLocation getAnimationLocation(Yautja animatable) {
        return ANIMATION;
    }

    public void setCustomAnimations(Yautja animatable, float partialTick) {
        YautjaAnimator.showHelmet(animatable, this.context());
        YautjaAnimator.showWristblades(animatable, this.context());
        BasicAnimationUtils.applyHeadRotations((LivingEntity)animatable, this.context(), partialTick, "gNeckUpper", 0.0f);
        BasicAnimationUtils.applyLimbRotations((LivingEntity)animatable, this.context(), partialTick, "gLeftArm", "gRightArm", "gLeftLeg", "gRightLeg", 0.0f, 0.0f);
    }

    private static void showWristblades(Yautja entity, AzAnimationContext<?> context) {
        AzBakedModel bakedModel = context.boneCache().getBakedModel();
        AzBone blade = bakedModel.getBoneOrNull("gWristBlade");
        if (blade != null) {
            blade.setHidden(!entity.getMainHandItem().isEmpty() && !entity.isAggressive());
        }
    }

    private static void showHelmet(Yautja entity, AzAnimationContext<?> context) {
        AzBakedModel bakedModel = context.boneCache().getBakedModel();
        AzBone helmet = bakedModel.getBoneOrNull("gArmorMask");
        if (helmet != null) {
            helmet.setHidden(!entity.hasMask());
        }
    }
}

