/*
 * Decompiled with CFR 0.152.
 */
package com.alien.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class IrradiatedAcidParticle
extends TextureSheetParticle {
    private static final float red = 0.30588236f;
    private static final float green = 0.39607844f;
    private static final float blue = 0.8980392f;
    private boolean isBlue = true;
    protected final SpriteSet spriteProvider;
    protected boolean reachedGround;

    public IrradiatedAcidParticle(ClientLevel clientWorld, double d, double e, double f, double g, double h, double i, SpriteSet spriteProvider) {
        super(clientWorld, d, e, f);
        this.xd = g;
        this.yd = h;
        this.zd = i;
        this.gravity = 3.0E-6f;
        this.quadSize *= 0.75f;
        this.lifetime = (int)(10.0 / ((double)this.random.nextFloat() * 0.8 + 0.2));
        this.reachedGround = false;
        this.hasPhysics = true;
        this.spriteProvider = spriteProvider;
        this.setSpriteFromAge(spriteProvider);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.lifetime && this.alpha > 0.0f) {
            this.xd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.zd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.age >= this.lifetime && this.alpha > 0.01f) {
                this.alpha -= 0.015f;
            }
            this.setColor();
        } else {
            this.remove();
        }
    }

    private void setColor() {
        if (this.isBlue) {
            this.setColor(0.30588236f, 0.39607844f, 0.8980392f);
        } else {
            this.setColor(1.0f, 1.0f, 1.0f);
        }
        this.isBlue = !this.isBlue;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float tickDelta) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + tickDelta) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }
}

