/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.ai;

import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.avp.common.registry.init.AVPSoundEvents;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DropOffEggGoal<T extends Xenomorph>
extends Goal {
    private static final List<BlockPos> EGG_GRID_POS_OFFSETS = DropOffEggGoal.generateSpiralOffsets(16);
    private final T eggCarryingXenomorph;
    private final Set<BlockPos> failedEggSpots;
    private BlockPos freeEggPos;
    private Path pathToFreeEggPos;

    public DropOffEggGoal(T eggCarryingXenomorph) {
        this.eggCarryingXenomorph = eggCarryingXenomorph;
        this.failedEggSpots = new HashSet<BlockPos>();
    }

    public boolean canUse() {
        boolean hasAccessibleFreeEggPos;
        if (this.isUnableToMoveOvomorph()) {
            return false;
        }
        this.freeEggPos = this.findFreeEggSpot(this.eggCarryingXenomorph.level(), this.eggCarryingXenomorph.blockPosition(), pos -> {
            BlockState state = this.eggCarryingXenomorph.level().getBlockState(pos);
            return state.entityCanStandOn((BlockGetter)this.eggCarryingXenomorph.level(), pos, this.eggCarryingXenomorph);
        }).orElse(null);
        if (this.freeEggPos != null) {
            this.pathToFreeEggPos = this.eggCarryingXenomorph.getNavigation().createPath(this.freeEggPos, 0);
            if (this.pathToFreeEggPos != null) {
                this.eggCarryingXenomorph.getNavigation().moveTo(this.pathToFreeEggPos, 0.5);
            }
        }
        boolean bl = hasAccessibleFreeEggPos = this.freeEggPos != null && this.pathToFreeEggPos != null;
        if (!hasAccessibleFreeEggPos) {
            this.getPassengerOvomorphs().forEach(Entity::discard);
        }
        return hasAccessibleFreeEggPos;
    }

    public boolean canContinueToUse() {
        return this.freeEggPos != null && this.pathToFreeEggPos != null && !this.pathToFreeEggPos.isDone() && this.pathToFreeEggPos.canReach() && !this.isUnableToMoveOvomorph();
    }

    public void start() {
        if (this.pathToFreeEggPos != null) {
            this.eggCarryingXenomorph.getNavigation().moveTo(this.pathToFreeEggPos, 0.5);
        }
    }

    public void tick() {
        if (this.freeEggPos == null || this.pathToFreeEggPos == null || !this.pathToFreeEggPos.canReach()) {
            this.freeEggPos = null;
            this.pathToFreeEggPos = null;
            return;
        }
        this.eggCarryingXenomorph.getNavigation().moveTo(this.pathToFreeEggPos, 0.5);
        if (this.eggCarryingXenomorph.distanceToSqr(this.freeEggPos.getCenter()) <= 4.0) {
            Vec3 center = this.freeEggPos.getCenter();
            this.getPassengerOvomorphs().forEach(ovomorph -> {
                this.eggCarryingXenomorph.level().playSound(null, (Entity)ovomorph, AVPSoundEvents.ENTITY_OVOMORPH_ROOT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                ovomorph.isRooted.set(true);
                ovomorph.stopRiding();
                ovomorph.setPos(center.x, center.y, center.z);
                float randomYaw = this.eggCarryingXenomorph.getRandom().nextFloat() * 360.0f;
                ovomorph.setYRot(randomYaw);
                ovomorph.setYHeadRot(randomYaw);
                ovomorph.yBodyRot = randomYaw;
                ovomorph.yRotO = randomYaw;
                ovomorph.yHeadRotO = randomYaw;
                ovomorph.yBodyRotO = randomYaw;
            });
        }
    }

    public void stop() {
        super.stop();
        this.failedEggSpots.clear();
        this.freeEggPos = null;
        this.pathToFreeEggPos = null;
    }

    private boolean isUnableToMoveOvomorph() {
        return this.eggCarryingXenomorph.getTarget() != null || !this.isCarryingOvomorph();
    }

    private boolean isCarryingOvomorph() {
        return !this.getPassengerOvomorphs().isEmpty();
    }

    private List<Ovomorph> getPassengerOvomorphs() {
        return this.eggCarryingXenomorph.getPassengers().stream().filter(passenger -> passenger instanceof Ovomorph).map(passenger -> (Ovomorph)passenger).toList();
    }

    private Optional<BlockPos> findFreeEggSpot(Level level, BlockPos center, Predicate<BlockPos> isWalkable) {
        boolean centerIsOdd = (center.getX() & 1) != 0 && (center.getZ() & 1) != 0;
        Optional<BlockPos> result = this.tryFindWithParity(level, center, isWalkable, centerIsOdd);
        if (result.isEmpty()) {
            result = this.tryFindWithParity(level, center, isWalkable, !centerIsOdd);
        }
        return result;
    }

    private Optional<BlockPos> tryFindWithParity(Level level, BlockPos center, Predicate<BlockPos> isWalkable, boolean useOdd) {
        int baseX = (center.getX() & 0xFFFFFFFE) + (useOdd ? 1 : 0);
        int baseZ = (center.getZ() & 0xFFFFFFFE) + (useOdd ? 1 : 0);
        BlockPos gridAlignedCenter = new BlockPos(baseX, center.getY(), baseZ);
        ArrayList<BlockPos> viable = new ArrayList<BlockPos>();
        for (BlockPos offset : EGG_GRID_POS_OFFSETS) {
            BlockPos pos2 = gridAlignedCenter.offset((Vec3i)offset);
            if ((pos2.getX() & 1) == 0 == useOdd || (pos2.getZ() & 1) == 0 == useOdd) continue;
            int verticalSearchRange = 4;
            for (int dy = -4; dy <= 4; ++dy) {
                BlockPos below;
                BlockPos adjustedPos = pos2.above(dy);
                if (this.failedEggSpots.contains(adjustedPos) || !isWalkable.test(below = adjustedPos.below())) continue;
                BlockState state = level.getBlockState(adjustedPos);
                BlockState aboveState = level.getBlockState(adjustedPos.above());
                if (!state.isAir() && !state.canBeReplaced() || !aboveState.isAir() && !aboveState.canBeReplaced() || !level.getEntities(null, new AABB(adjustedPos)).isEmpty()) continue;
                viable.add(adjustedPos.immutable());
            }
        }
        viable.sort(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)gridAlignedCenter)));
        for (int i = 0; i < Math.min(viable.size(), 5); ++i) {
            BlockPos pos3 = (BlockPos)viable.get(i);
            Path path = this.eggCarryingXenomorph.getNavigation().createPath(pos3, 0);
            if (path != null && path.canReach()) {
                return Optional.of(pos3);
            }
            this.failedEggSpots.add(pos3);
        }
        return Optional.empty();
    }

    private static List<BlockPos> generateSpiralOffsets(int maxDist) {
        int step = 2;
        ArrayList<BlockPos> offsets = new ArrayList<BlockPos>();
        for (int dist = 0; dist <= maxDist; dist += step) {
            for (int dx = -dist; dx <= dist; dx += step) {
                int dz = dist - Math.abs(dx);
                if ((dz & 1) != 0) continue;
                offsets.add(new BlockPos(dx, 0, dz));
                if (dz == 0) continue;
                offsets.add(new BlockPos(dx, 0, -dz));
            }
        }
        return offsets;
    }
}

