/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.acid;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.acid.AcidBlockDamageUtil;
import com.alien.common.gameplay.entity.acid.AcidEntityDamageUtil;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.common.registry.init.AVPDataKeys;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.util.GravityUtil;
import com.lib.common.network.DataAccessor;
import com.lib.common.network.DataUser;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class Acid
extends Entity
implements DataUser {
    public static final int MAX_MULTIPLIER = 5;
    private static final int DEFAULT_MAX_LIFE_IN_TICKS = 400;
    private static final int MIN_TICKS_UNTIL_PARTICLES = 5;
    private static final String IS_NETHER_AFFLICTED_KEY = "isNetherAfflicted";
    private static final String IS_IRRADIATED_KEY = "isIrradiated";
    private static final EntityDataAccessor<Boolean> IS_NETHER_AFFLICTED = SynchedEntityData.defineId(Acid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> IS_IRRADIATED = SynchedEntityData.defineId(Acid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final DataAccessor<Integer> multiplier = new DataAccessor<Integer>(this, AVPDataKeys.ACID_MULTIPLIER);
    public final DataAccessor<Integer> tickCountForCurrentMultiplier = new DataAccessor<Integer>(this, AVPDataKeys.ACID_TICK_COUNT_FOR_MULTIPLIER);
    private int particleTickCounter = 0;

    public Acid(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(false);
        this.refreshDimensions();
        this.multiplier.onChange($ -> this.refreshDimensions());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(IS_NETHER_AFFLICTED, (Object)false);
        builder.define(IS_IRRADIATED, (Object)false);
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (!level.isClientSide && !this.horizontalCollision) {
            GravityUtil.apply(this);
        }
        AcidBlockDamageUtil.damageBlocks(this);
        AcidEntityDamageUtil.damageEntities(this);
        this.particleTickCounter += this.getMultiplier();
        this.createParticlesAndSounds(level);
        if (!level.isClientSide) {
            int increment = this.getMultiplier() * (this.isInWater() ? 2 : 1);
            this.tickCountForCurrentMultiplier.set(this.tickCountForCurrentMultiplier.get() + increment);
            if (this.tickCountForCurrentMultiplier.get() > 400) {
                this.decreaseMultiplier();
                this.tickCountForCurrentMultiplier.reset();
            }
            if (this.getMultiplier() == 0) {
                this.kill();
            }
        }
    }

    public boolean isNetherAfflicted() {
        return (Boolean)this.entityData.get(IS_NETHER_AFFLICTED);
    }

    public void setNetherAfflicted(boolean isNetherAfflicted) {
        this.entityData.set(IS_NETHER_AFFLICTED, (Object)isNetherAfflicted);
    }

    public boolean isIrradiated() {
        return (Boolean)this.entityData.get(IS_IRRADIATED);
    }

    public void setIrradiated(boolean isIrradiated) {
        this.entityData.set(IS_IRRADIATED, (Object)isIrradiated);
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        this.setNetherAfflicted(compoundTag.getBoolean(IS_NETHER_AFFLICTED_KEY));
        this.setIrradiated(compoundTag.getBoolean(IS_IRRADIATED_KEY));
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        compoundTag.putBoolean(IS_NETHER_AFFLICTED_KEY, this.isNetherAfflicted());
        compoundTag.putBoolean(IS_IRRADIATED_KEY, this.isIrradiated());
    }

    public void decreaseMultiplier() {
        this.setMultiplier(this.getMultiplier() - 1);
    }

    private void createParticlesAndSounds(Level level) {
        if (!level.isClientSide) {
            return;
        }
        if (this.particleTickCounter < 5) {
            return;
        }
        this.particleTickCounter = 0;
        Option<AlienVariantType> alienVariantTypeOption = AlienVariantTypes.getFor(this);
        for (int i = 0; i < this.getMultiplier(); ++i) {
            if (this.isInWater()) {
                level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
            alienVariantTypeOption.ifSome(alienVariantType -> level.addAlwaysVisibleParticle((ParticleOptions)alienVariantType.acidParticleType().get(), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0));
        }
    }

    public int getMultiplier() {
        return this.multiplier.get();
    }

    public void setMultiplier(int multiplier) {
        this.multiplier.set(Mth.clamp((int)multiplier, (int)0, (int)5));
        this.tickCountForCurrentMultiplier.reset();
        this.refreshDimensions();
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose pose) {
        EntityDimensions originalDimensions = super.getDimensions(pose);
        float originalWidth = originalDimensions.width();
        float maxScale = 1.0f / originalWidth;
        float scaleStep = Mth.map((float)this.getMultiplier(), (float)0.0f, (float)5.0f, (float)1.0f, (float)maxScale);
        return originalDimensions.scale(scaleStep, 1.0f);
    }

    public boolean fireImmune() {
        return true;
    }

    public void age() {
        this.tickCountForCurrentMultiplier.set(this.tickCountForCurrentMultiplier.get() + this.getMultiplier());
    }
}

