/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.HiveManager;
import com.alien.common.gameplay.entity.living.alien.xenomorph.drone.Drone;
import com.alien.common.gameplay.entity.living.alien.xenomorph.runner.Runner;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.alien.common.gameplay.level.saveddata.StrainLeakData;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.alien.common.util.AcidBleedUtil;
import com.alien.common.util.AlienTransitionUtil;
import com.avp.AVP;
import com.avp.common.config.AVPConfig;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.registry.key.AVPBiomeKeys;
import com.avp.common.registry.tag.AVPDamageTypesTags;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.registry.tag.AVPMobEffectTags;
import com.avp.common.util.MovementAnalyzer;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.entity.manager.GeneContainer;
import com.lib.common.gameplay.entity.manager.GeneManager;
import com.lib.common.gameplay.entity.manager.VibrationSystemManager;
import com.lib.common.gameplay.gene.Genes;
import com.lib.common.model.GeneCarrier;
import com.lib.common.network.DataAccessor;
import com.lib.common.network.DataUser;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Alien
extends Monster
implements DataUser {
    private static final String NBT_HOST_TYPE = "hostType";
    private static final String NBT_JELLY_COUNT = "jellyCount";
    public final DataAccessor<Boolean> hasTarget = new DataAccessor<Boolean>(this, AVPDataKeys.ENTITY_HAS_TARGET);
    public final DataAccessor<Boolean> isPoisoned = new DataAccessor<Boolean>(this, AVPDataKeys.ALIEN_IS_POISONED);
    public final DataAccessor<Boolean> isMovingHorizontally = new DataAccessor<Boolean>(this, AVPDataKeys.ENTITY_IS_MOVING_HORIZONTALLY);
    protected final HiveManager hiveManager = new HiveManager(this);
    protected final MovementAnalyzer movementAnalyzer = new MovementAnalyzer((Entity)this);
    private final VibrationSystemManager vibrationSystemManager = this.createVibrationSystemManager();
    private Option<EntityType<?>> hostTypeOption;
    private int jellyCount;
    private int lastHurtTimeInTicks;
    protected AVPConfig.StatsConfigs.AdvancedStats config;

    protected Alien(EntityType<? extends Alien> entityType, Level level) {
        super(entityType, level);
        this.hostTypeOption = Option.ofNullable(this.getDefaultHostType(entityType));
        this.jellyCount = 0;
        this.lastHurtTimeInTicks = 0;
    }

    @Nullable
    public abstract EntityType<? extends Alien> getTypeForVariant(AlienVariant var1);

    protected abstract float getHealthRegenPerSecond();

    protected VibrationSystemManager createVibrationSystemManager() {
        return new VibrationSystemManager((Mob)this, 2.5f, 32);
    }

    public float maxUpStep() {
        return 1.5f;
    }

    private EntityType<? extends Entity> getDefaultHostType(EntityType<? extends Alien> entityType) {
        if (entityType.is(AVPEntityTypeTags.RUNNERS) || entityType.is(AVPEntityTypeTags.PROWLERS) || entityType.is(AVPEntityTypeTags.CRUSHERS)) {
            return EntityType.PIG;
        }
        if (entityType.is(AVPEntityTypeTags.SPITTERS)) {
            return EntityType.LLAMA;
        }
        return EntityType.VILLAGER;
    }

    protected boolean canBleedAcid() {
        return true;
    }

    protected boolean canHeal() {
        int requiredTicksAfterHurtToHeal = 200;
        return this.getTarget() == null && this.tickCount > this.getLastHurtByMobTimestamp() + requiredTicksAfterHurtToHeal;
    }

    public void setTarget(@Nullable LivingEntity livingEntity) {
        super.setTarget(livingEntity);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            this.hiveManager.hive().filter(hive -> hive.getSpaceManager().isEntityWithinHive((Entity)player)).ifSome(hive -> hive.getBossBarManager().trackPlayer(player));
        }
    }

    public AlienVariant getVariant() {
        if (this.isAberrant()) {
            return AlienVariant.ABERRANT;
        }
        if (this.isIrradiated()) {
            return AlienVariant.IRRADIATED;
        }
        if (this.isNetherAfflicted()) {
            return AlienVariant.NETHER;
        }
        return AlienVariant.NORMAL;
    }

    public boolean isAberrant() {
        return Objects.equals(this.getType(), this.getTypeForVariant(AlienVariant.ABERRANT));
    }

    public boolean isIrradiated() {
        return Objects.equals(this.getType(), this.getTypeForVariant(AlienVariant.IRRADIATED));
    }

    public boolean isNetherAfflicted() {
        return Objects.equals(this.getType(), this.getTypeForVariant(AlienVariant.NETHER));
    }

    private void applyMalusBasedOnVariant() {
        if (this.isNetherAfflicted()) {
            this.setPathfindingMalus(PathType.LAVA, 0.0f);
            this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
            this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        } else {
            this.setPathfindingMalus(PathType.LAVA, PathType.LAVA.getMalus());
            this.setPathfindingMalus(PathType.DANGER_FIRE, PathType.DANGER_FIRE.getMalus());
            this.setPathfindingMalus(PathType.DAMAGE_FIRE, PathType.DAMAGE_FIRE.getMalus());
        }
    }

    public int getJellyCount() {
        return this.jellyCount;
    }

    public void setJellyCount(int jellyCount) {
        this.jellyCount = Math.max(jellyCount, 0);
    }

    public boolean isPoisoned() {
        return this.isPoisoned.get();
    }

    public void setPoisoned(boolean isPoisoned) {
        this.isPoisoned.set(isPoisoned);
    }

    public boolean isRoyal() {
        return this.getType().is(AVPEntityTypeTags.ROYAL_ALIENS);
    }

    protected boolean canEntityRideAlien(@NotNull Entity passenger) {
        return false;
    }

    protected final boolean canAddPassenger(@NotNull Entity passenger) {
        return super.canAddPassenger(passenger) && this.canEntityRideAlien(passenger);
    }

    protected boolean canAlienRideVehicle(@NotNull Entity vehicle) {
        return !(vehicle instanceof Boat) && !(vehicle instanceof Minecart);
    }

    protected final boolean canRide(@NotNull Entity vehicle) {
        return super.canRide(vehicle) && this.canAlienRideVehicle(vehicle);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        AlienVariantType alienVariantType = AlienVariantTypes.getFor(this.getVariant());
        HiveLevelData.getOrCreate((Level)level.getLevel()).andThen(hiveLevelData -> hiveLevelData.findNearestHive(this.blockPosition(), hive -> Objects.equals((Object)hive.getVariant(), (Object)alienVariantType.variant()))).ifSome(hive -> {
            boolean joinedHiveSuccessfully = this.hiveManager.tryJoinHive((Hive)hive);
            if (joinedHiveSuccessfully) {
                hive.getReserveManager().add(this.getType(), -1);
                hive.getLeadershipManager().getLeader().map(leader -> ((GeneCarrier)((Object)leader)).getOrCreateGeneManager().getGeneContainer()).ifSome(geneContainer -> {
                    GeneContainer alienGeneCarrier = ((GeneCarrier)((Object)this)).getOrCreateGeneManager().getGeneContainer();
                    geneContainer.transfer(alienGeneCarrier, true);
                });
            }
        });
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void tick() {
        super.tick();
        this.hiveManager.tick();
        this.vibrationSystemManager.tick();
        if (!this.level().isClientSide) {
            this.movementAnalyzer.tick();
            this.hasTarget.set(this.getTarget() != null);
            this.isMovingHorizontally.set(this.movementAnalyzer.isMovingHorizontally());
            if (this.getVehicle() != null && !this.canRide(this.getVehicle())) {
                this.stopRiding();
            }
            if (!this.getPassengers().isEmpty()) {
                List<Entity> passengersToRemove = this.getPassengers().stream().filter(Predicate.not(this::canEntityRideAlien)).toList();
                passengersToRemove.forEach(Entity::stopRiding);
            }
            this.healPassively();
            this.applyMalusBasedOnVariant();
            this.applyDynamicAttributes(this.config);
            this.becomeIrradiated();
        }
    }

    public void updateDynamicGameEventListener(@NotNull BiConsumer<DynamicGameEventListener<?>, ServerLevel> biConsumer) {
        this.vibrationSystemManager.updateDynamicGameEventListener(biConsumer);
    }

    private void becomeIrradiated() {
        if (this.tickCount % 60 != 0) {
            return;
        }
        if (!this.level().getBiome(this.blockPosition()).is(AVPBiomeKeys.NUKED_BIOME)) {
            return;
        }
        if (!this.isAlive()) {
            return;
        }
        if (this.getRandom().nextIntBetweenInclusive(1, 100) >= 90) {
            AlienTransitionUtil.transitionIntoVariant(this, AlienVariant.IRRADIATED);
        }
    }

    private void healPassively() {
        if (this.tickCount % 20 != 0) {
            return;
        }
        if (this.getHealth() >= this.getMaxHealth()) {
            return;
        }
        if (!this.isAlive()) {
            return;
        }
        if (this.canHeal()) {
            this.heal(this.getHealthRegenPerSecond());
        }
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        return damageSource.is(AVPDamageTypesTags.DOES_NOT_HURT_ALIENS) || super.isInvulnerableTo(damageSource);
    }

    public boolean killedEntity(@NotNull ServerLevel level, @NotNull LivingEntity entity) {
        boolean killedEntity = super.killedEntity(level, entity);
        if (killedEntity && AlienVariantTypes.getFor(this.getVariant()).canReproduce() && !entity.getType().is(AVPEntityTypeTags.ALIENS)) {
            this.hiveManager.hive().ifSome(hive -> {
                boolean wasRunnerHostKilled = entity.getType().is(AVPEntityTypeTags.RUNNER_HOSTS);
                int bonusCount = 1 + (int)this.getGeneManager().getGeneContainer().getActiveGeneMap().getValue(Genes.BONUS_EMBRYO_COUNT);
                EntityType<? extends Alien> alienEntityType = wasRunnerHostKilled ? Runner.getType(hive.getVariant()) : Drone.getType(hive.getVariant());
                hive.getReserveManager().add(alienEntityType, bonusCount);
            });
        }
        return killedEntity;
    }

    public boolean hurt(@NotNull DamageSource damageSource, float damage) {
        boolean isHurt = super.hurt(damageSource, damage);
        if (isHurt) {
            Entity entity;
            this.lastHurtTimeInTicks = this.tickCount;
            AlienVariantType alienVariantType = AlienVariantTypes.getFor(this);
            if (this.isNetherAfflicted() && !damageSource.is(DamageTypeTags.AVOIDS_GUARDIAN_THORNS) && (entity = damageSource.getDirectEntity()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.igniteForSeconds(4.0f);
            }
            if (damageSource.getEntity() != null) {
                this.gameEvent(alienVariantType.cryForHelpEvent().getHolder());
            }
            if (this.canBleedAcid() && damageSource != this.damageSources().genericKill()) {
                Vec3 randomPos = AcidBleedUtil.computeRandomPosFromBoundingBox((LivingEntity)this);
                AcidBleedUtil.spawnAcid((LivingEntity)this, damage, randomPos);
            }
        }
        return isHurt;
    }

    public int getAirSupply() {
        return Integer.MAX_VALUE;
    }

    protected float getWaterSlowDown() {
        return 0.9f;
    }

    public int calculateFallDamage(float fallDistance, float damageMultiplier) {
        return fallDistance < 16.0f ? 0 : super.calculateFallDamage(fallDistance, damageMultiplier);
    }

    public int getMaxFallDistance() {
        return 14;
    }

    public boolean canBeAffected(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.getEffect().is(AVPMobEffectTags.DOES_NOT_AFFECT_ALIENS)) {
            return false;
        }
        return super.canBeAffected(mobEffectInstance);
    }

    public boolean dampensVibrations() {
        return true;
    }

    public boolean fireImmune() {
        return this.isNetherAfflicted() || super.fireImmune();
    }

    public boolean isPersistenceRequired() {
        return super.isPersistenceRequired() || this.hiveManager.hive().filter(hive -> hive.isAngry() || hive.getLeadershipManager().isLeader((Entity)this)).isSome();
    }

    public void remove(@NotNull Entity.RemovalReason removalReason) {
        super.remove(removalReason);
        switch (removalReason) {
            case KILLED: {
                this.hiveManager.hive().ifSome(hive -> hive.removeHiveMember((Entity)this));
                break;
            }
            case DISCARDED: {
                this.hiveManager.hive().ifSome(hive -> {
                    hive.removeHiveMember((Entity)this);
                    if (hive.getSpaceManager().isEntityWithinHive((Entity)this)) {
                        hive.getReserveManager().add(this.getType(), 1);
                    } else {
                        StrainLeakData.getOrCreate(this.level()).ifSome(strainLeakData -> {
                            AlienVariant alienVariant = this.getVariant();
                            boolean wasAlienVariantAlreadyPresent = strainLeakData.hasVariant(alienVariant);
                            AlienVariantType alienVariantType = AlienVariantTypes.getFor(this);
                            Level patt0$temp = this.level();
                            if (!(patt0$temp instanceof ServerLevel)) {
                                return;
                            }
                            ServerLevel serverLevel = (ServerLevel)patt0$temp;
                            String strainBasedLeakMessage = this.getStrainLeakMessageForVariant(alienVariant);
                            if (strainBasedLeakMessage == null) {
                                return;
                            }
                            strainLeakData.add(alienVariant, 1);
                            if (!wasAlienVariantAlreadyPresent) {
                                for (ServerPlayer player : serverLevel.players()) {
                                    player.sendSystemMessage((Component)Component.literal((String)strainBasedLeakMessage).withStyle(new ChatFormatting[]{alienVariantType.chatColor(), ChatFormatting.ITALIC}));
                                }
                            }
                        });
                    }
                });
                break;
            }
        }
    }

    @Nullable
    private String getStrainLeakMessageForVariant(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> "The perfect organism has found a new world to conquer...";
            case AlienVariant.NETHER -> "Hell has found its way into this plane of existence...";
            case AlienVariant.ABERRANT -> "Genetic experiments have found their way into the wide open world...";
            case AlienVariant.IRRADIATED -> null;
        };
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.hiveManager.load(compoundTag);
        if (compoundTag.contains(NBT_JELLY_COUNT)) {
            this.setJellyCount(compoundTag.getInt(NBT_JELLY_COUNT));
        }
        if (compoundTag.contains(NBT_HOST_TYPE)) {
            String resourceLocationString = compoundTag.getString(NBT_HOST_TYPE);
            ResourceLocation resourceLocation = ResourceLocation.parse((String)resourceLocationString);
            Optional entityTypeHolderOptional = BuiltInRegistries.ENTITY_TYPE.getHolder(resourceLocation);
            entityTypeHolderOptional.ifPresent($ -> {
                this.hostTypeOption = Option.some((Object)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation)));
            });
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        this.hiveManager.save(compoundTag);
        compoundTag.putInt(NBT_JELLY_COUNT, this.getJellyCount());
        this.hostTypeOption.ifSome(hostType -> {
            ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)this.hostTypeOption.unwrap()));
            compoundTag.putString(NBT_HOST_TYPE, resourceLocation.toString());
        });
    }

    public GeneManager getGeneManager() {
        return ((GeneCarrier)((Object)this)).getOrCreateGeneManager();
    }

    public HiveManager getHiveManager() {
        return this.hiveManager;
    }

    public Option<EntityType<?>> getHostType() {
        return this.hostTypeOption;
    }

    public int getLastHurtTimeInTicks() {
        return this.lastHurtTimeInTicks;
    }

    @Nullable
    public Integer getMaxJellyToGrowth() {
        return null;
    }

    public MovementAnalyzer getMovementAnalyzer() {
        return this.movementAnalyzer;
    }

    public VibrationSystemManager getVibrationSystemManager() {
        return this.vibrationSystemManager;
    }

    public void setHostType(EntityType<?> hostType) {
        this.hostTypeOption = Option.some(hostType);
    }

    public void applyDynamicAttributes(AVPConfig.StatsConfigs.AdvancedStats config) {
        if (this.isAberrant()) {
            this.applyAttributes(config, AVP.config.statsConfigs.ABERRANT_STATS_MULTIPLIER);
        } else if (this.isIrradiated()) {
            this.applyAttributes(config, AVP.config.statsConfigs.IRRADIATED_STATS_MULTIPLIER);
        }
    }

    private void applyAttributes(AVPConfig.StatsConfigs.AdvancedStats config, float scaleFactor) {
        this.setAttribute((Holder<Attribute>)Attributes.MAX_HEALTH, config.health * scaleFactor);
        this.setAttribute((Holder<Attribute>)Attributes.ATTACK_DAMAGE, config.attackDamage * scaleFactor);
        this.setAttribute((Holder<Attribute>)Attributes.ARMOR, config.armor * scaleFactor);
        this.setAttribute((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, config.armorToughness * scaleFactor);
    }

    private void setAttribute(Holder<Attribute> attribute, float value) {
        AttributeInstance instance = this.getAttribute(attribute);
        if (instance != null) {
            instance.setBaseValue((double)value);
        }
    }

    public static AttributeSupplier.Builder applyFrom(AVPConfig.StatsConfigs.AdvancedStats config, AttributeSupplier.Builder builder) {
        builder.add(Attributes.ARMOR, (double)config.armor);
        builder.add(Attributes.ARMOR_TOUGHNESS, (double)config.armorToughness);
        builder.add(Attributes.ATTACK_DAMAGE, (double)config.attackDamage);
        builder.add(Attributes.FOLLOW_RANGE, (double)config.followRange);
        builder.add(Attributes.KNOCKBACK_RESISTANCE, (double)config.knockbackResistance);
        builder.add(Attributes.MAX_HEALTH, (double)config.health);
        builder.add(Attributes.MOVEMENT_SPEED, (double)config.moveSpeed);
        builder.add(Attributes.JUMP_STRENGTH, (double)0.1f);
        return builder;
    }
}

