/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.level.gameevent.listener.ResinSpreadListener;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.alien.common.model.resin.ReadableResinData;
import com.alien.common.model.resin.ResinData;
import com.avp.AVP;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.NBTSerializable;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ResinManager
implements GameEventListener.Provider<ResinSpreadListener>,
NBTSerializable {
    private static final String NBT_RESIN_DATA = "resinData";
    private final Alien alien;
    @Nullable
    private final ReadableResinData baseResinData;
    private final DynamicGameEventListener<ResinSpreadListener> dynamicResinSpreadListener;
    private final ResinSpreadListener resinSpreadListener;
    @Nullable
    private ResinData resinData;
    private int ticksSinceLastResinProduction = 0;
    private int ticksSinceAttemptedNodePlacement = 0;

    public ResinManager(Alien alien, @Nullable ResinData resinData) {
        this.alien = alien;
        this.baseResinData = resinData;
        this.resinData = resinData;
        EntityPositionSource positionSource = new EntityPositionSource((Entity)alien, 0.0f);
        ResinSpreadListener.SpreaderType.Entity spreadType = new ResinSpreadListener.SpreaderType.Entity((Entity)alien);
        this.resinSpreadListener = new ResinSpreadListener((PositionSource)positionSource, spreadType);
        this.dynamicResinSpreadListener = new DynamicGameEventListener((GameEventListener)this.resinSpreadListener);
    }

    @NotNull
    public ResinSpreadListener getListener() {
        return this.resinSpreadListener;
    }

    public void tick() {
        Level level = this.alien.level();
        if (level.isClientSide || this.baseResinData == null || this.resinData == null) {
            return;
        }
        ++this.ticksSinceLastResinProduction;
        this.ticksSinceAttemptedNodePlacement = Math.max(0, this.ticksSinceAttemptedNodePlacement - 1);
        if (this.ticksSinceLastResinProduction < this.resinData.tickRate()) {
            return;
        }
        int factor = this.resinData.tickRate() == 0 ? 0 : this.ticksSinceLastResinProduction / this.resinData.tickRate();
        int accumulatedResin = factor * this.resinData.resinPerTick();
        this.resinData.addResin(accumulatedResin);
        this.ticksSinceLastResinProduction = 0;
        if (this.resinData.resin() < this.resinData.resinMax() || this.ticksSinceAttemptedNodePlacement > 0 || !this.canSpreadResinAtAlienPosition()) {
            return;
        }
        AlienVariantType alienVariantType = AlienVariantTypes.getFor(this.alien);
        this.alien.gameEvent(alienVariantType.resinSpreadEvent().getHolder());
        if (this.resinData.resin() >= this.resinData.resinMax()) {
            Option<BlockPos> suitableResinNodeBlockPosOption = this.findSuitableResinNodeBlockPos(level, alienVariantType.resinReplaceableTag());
            if (suitableResinNodeBlockPosOption.isNone()) {
                this.ticksSinceAttemptedNodePlacement = 200;
                return;
            }
            BlockState resinNodeBlockState = alienVariantType.resinNode().get().defaultBlockState();
            this.alien.level().setBlockAndUpdate((BlockPos)suitableResinNodeBlockPosOption.unwrap(), resinNodeBlockState);
        }
    }

    private boolean canSpreadResinAtAlienPosition() {
        return this.alien.level().getBrightness(LightLayer.SKY, this.alien.blockPosition()) == 0 && this.alien.getTarget() == null && !this.alien.isUnderWater() && this.alien.tickCount > this.alien.getLastHurtTimeInTicks() + 200 && this.alien.getHiveManager().hive().filter(hive -> !hive.isAngry() && hive.getSpaceManager().isEntityWithinHive((Entity)this.alien)).isSome();
    }

    private Option<BlockPos> findSuitableResinNodeBlockPos(Level level, TagKey<Block> replaceableTagKey) {
        BlockPos origin = this.alien.blockPosition();
        BlockPos below = origin.below();
        BlockState belowState = level.getBlockState(below);
        if (belowState.is(replaceableTagKey)) {
            return Option.some((Object)below);
        }
        BlockPos.MutableBlockPos targetMutablePos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos belowTargetMutablePos = new BlockPos.MutableBlockPos();
        int radius = 2;
        for (int r = 0; r <= radius; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                int dz = r - Math.abs(dx);
                for (int sign : new int[]{1, -1}) {
                    int actualDz = dz * sign;
                    for (int dy = -1; dy <= 1; ++dy) {
                        targetMutablePos.set(origin.getX() + dx, origin.getY() + dy, origin.getZ() + actualDz);
                        belowTargetMutablePos.set(targetMutablePos.getX(), targetMutablePos.getY() - 1, targetMutablePos.getZ());
                        BlockState targetStateToReplace = level.getBlockState((BlockPos)targetMutablePos);
                        if (!targetStateToReplace.isAir() && !targetStateToReplace.canBeReplaced() || !level.getBlockState((BlockPos)belowTargetMutablePos).isSolidRender((BlockGetter)level, (BlockPos)belowTargetMutablePos)) continue;
                        return Option.some((Object)targetMutablePos.immutable());
                    }
                }
            }
        }
        return Option.none();
    }

    public void updateDynamicGameEventListener(@NotNull BiConsumer<DynamicGameEventListener<?>, ServerLevel> biConsumer) {
        Level level = this.alien.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            biConsumer.accept(this.dynamicResinSpreadListener, serverLevel);
        }
    }

    @Nullable
    public ReadableResinData baseResinData() {
        return this.baseResinData;
    }

    @Nullable
    public ResinData resinData() {
        return this.resinData;
    }

    @Override
    public void load(CompoundTag compoundTag) {
        if (compoundTag.contains(NBT_RESIN_DATA)) {
            ResinData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.getCompound(NBT_RESIN_DATA))).resultOrPartial(arg_0 -> ((Logger)AVP.LOGGER).error(arg_0)).ifPresent(resinData -> {
                this.resinData = resinData;
            });
        }
    }

    @Override
    public void save(CompoundTag compoundTag) {
        if (this.resinData != null) {
            ResinData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.resinData).resultOrPartial(arg_0 -> ((Logger)AVP.LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.put(NBT_RESIN_DATA, tag));
        }
    }
}

