/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.adolescent;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.GrowthManager;
import com.alien.common.gameplay.entity.living.alien.adolescent.AdolescentAnimationDispatcher;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.registry.init.AlienEntityTypes;
import com.alien.common.util.AlienPredicates;
import com.alien.common.util.XenomorphGrowthUtil;
import com.avp.AVP;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.AVPPredicates;
import com.lib.common.network.DataAccessor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Adolescent
extends Alien {
    private static final String NBT_HAS_DORSAL_TUBES = "hasDorsalTubes";
    public final DataAccessor<Boolean> hasDorsalTubes = new DataAccessor<Boolean>(this, AVPDataKeys.ADOLESCENT_HAS_DORSAL_TUBES);
    private final AdolescentAnimationDispatcher animationDispatcher = new AdolescentAnimationDispatcher(this);
    private final GrowthManager growthManager = new GrowthManager(this, XenomorphGrowthUtil.GROW_UP_CALLBACK).setGrowOverTime(true);

    public static AttributeSupplier.Builder createAdolescentAttributes() {
        return Adolescent.applyFrom(AVP.config.statsConfigs.ADOLESCENT_STATS, Monster.createMonsterAttributes());
    }

    public Adolescent(EntityType<? extends Adolescent> entityType, Level level) {
        super(entityType, level);
        this.config = AVP.config.statsConfigs.ADOLESCENT_STATS;
    }

    @Override
    @Nullable
    public EntityType<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Adolescent.getType(alienVariant, this.isRoyal());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.0, 1.2, entity -> {
            boolean bl;
            if (entity instanceof Alien) {
                Alien alien = (Alien)entity;
                bl = AlienPredicates.areAliensEnemies(this, alien);
            } else {
                bl = !AVPPredicates.IS_IMMORTAL.test((LivingEntity)entity);
            }
            return bl;
        }));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
    }

    @Override
    public void tick() {
        super.tick();
        this.growthManager.tick();
        if (!this.level().isClientSide) {
            this.getHostType().ifSome(hostType -> this.hasDorsalTubes.set(!hostType.is(AVPEntityTypeTags.RUNNER_HOSTS)));
        }
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.ADOLESCENT_STATS.healthRegenPerSecond;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.growthManager.load(compoundTag);
        if (compoundTag.contains(NBT_HAS_DORSAL_TUBES)) {
            this.hasDorsalTubes.set(compoundTag.getBoolean(NBT_HAS_DORSAL_TUBES));
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        this.growthManager.save(compoundTag);
        compoundTag.putBoolean(NBT_HAS_DORSAL_TUBES, this.hasDorsalTubes.get().booleanValue());
    }

    @Override
    public Integer getMaxJellyToGrowth() {
        return 1;
    }

    public AdolescentAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    @Nullable
    public static EntityType<? extends Alien> getType(AlienVariant alienVariant, boolean isRoyal) {
        if (isRoyal) {
            return switch (alienVariant) {
                default -> throw new MatchException(null, null);
                case AlienVariant.NORMAL -> AlienEntityTypes.ROYAL_ADOLESCENT.get();
                case AlienVariant.NETHER -> AlienEntityTypes.ROYAL_NETHER_ADOLESCENT.get();
                case AlienVariant.ABERRANT -> AlienEntityTypes.ROYAL_ABERRANT_ADOLESCENT.get();
                case AlienVariant.IRRADIATED -> null;
            };
        }
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.ADOLESCENT.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_ADOLESCENT.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_ADOLESCENT.get();
            case AlienVariant.IRRADIATED -> null;
        };
    }
}

