/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.parasite;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.parasite.ParasiteAttachmentManager;
import com.alien.common.model.alien.FreeMob;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.util.AVPPredicates;
import com.lib.common.network.DataAccessor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class Parasite
extends Alien {
    public final DataAccessor<Boolean> isFertile = new DataAccessor<Boolean>(this, AVPDataKeys.PARASITE_IS_FERTILE);
    protected final ParasiteAttachmentManager attachmentManager = new ParasiteAttachmentManager(this);

    protected Parasite(EntityType<? extends Parasite> entityType, Level level) {
        super(entityType, level);
        this.isFertile.onChange(this::handleFertilityChange);
        this.isFertile.onLoad(this::handleFertilityChange);
    }

    public void restoreAllGoals() {
        this.removeAllGoals(AVPPredicates.alwaysTrue());
        this.registerGoals();
    }

    @Override
    public void tick() {
        LivingEntity currentTarget;
        super.tick();
        this.attachmentManager.tick();
        if (!this.level().isClientSide && (currentTarget = this.getTarget()) != null && !this.isValidHost(currentTarget)) {
            this.setTarget(null);
        }
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        if (this.canAttachToHost(entity)) {
            this.startRiding(entity, true);
        }
        return true;
    }

    protected boolean canAttachToHost(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && this.isValidHost(livingEntity = (LivingEntity)entity) && !AVPPredicates.hasShield(entity) && !this.isPassenger() && !this.isVehicle();
    }

    protected boolean isValidHost(LivingEntity target) {
        return this.isFertile.get() != false && AVPPredicates.isFreeHost(this, (Entity)target);
    }

    public boolean startRiding(@NotNull Entity entity, boolean bl) {
        boolean isRiding = super.startRiding(entity, bl);
        if (isRiding) {
            this.tryUpdatePlayerRiding(entity);
        }
        return isRiding;
    }

    public void stopRiding() {
        LivingEntity host = this.attachmentManager.getHost();
        if (host instanceof Mob) {
            Mob mob = (Mob)host;
            ((FreeMob)mob).restoreFreedom();
        }
        super.stopRiding();
        this.tryUpdatePlayerRiding((Entity)host);
    }

    protected void doPush(@NotNull Entity entity) {
        super.doPush(entity);
        if (this.canAttachToHost(entity)) {
            this.startRiding(entity);
        }
    }

    private void tryUpdatePlayerRiding(Entity entity) {
        if (!this.level().isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.connection.send((Packet)new ClientboundSetPassengersPacket(entity));
        }
    }

    @Override
    protected boolean canHeal() {
        return this.isFertile.get() != false && super.canHeal();
    }

    @Override
    protected boolean canBleedAcid() {
        return this.isFertile.get() != false || this.attachmentManager.isAttachedToHost();
    }

    public boolean isPushable() {
        return this.isFertile.get();
    }

    public ParasiteAttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    private void handleFertilityChange(Boolean isFertile) {
        if (!isFertile.booleanValue()) {
            ((FreeMob)((Object)this)).removeFreedom();
            this.removeAllGoals(AVPPredicates.alwaysTrue());
        } else {
            ((FreeMob)((Object)this)).restoreFreedom();
            this.restoreAllGoals();
        }
    }
}

