/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph;

import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.EggPickupRequestListener;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EggPickupManager
implements GameEventListener.Provider<EggPickupRequestListener> {
    private final DynamicGameEventListener<EggPickupRequestListener> dynamicEggPickupRequestListener;
    private final EggPickupRequestListener eggPickupRequestListener;
    private final Xenomorph xenomorph;
    private Ovomorph targetOvomorph;

    public EggPickupManager(Xenomorph xenomorph) {
        this.eggPickupRequestListener = new EggPickupRequestListener((Entity)xenomorph, this::acknowledgePickupRequest);
        this.dynamicEggPickupRequestListener = new DynamicGameEventListener((GameEventListener)this.eggPickupRequestListener);
        this.xenomorph = xenomorph;
    }

    @NotNull
    public EggPickupRequestListener getListener() {
        return this.eggPickupRequestListener;
    }

    public void updateDynamicGameEventListener(@NotNull BiConsumer<DynamicGameEventListener<?>, ServerLevel> biConsumer) {
        Level level = this.xenomorph.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            biConsumer.accept(this.dynamicEggPickupRequestListener, serverLevel);
        }
    }

    public void tick() {
        if (this.xenomorph.level().isClientSide) {
            return;
        }
        this.getPassengerOvomorphs().stream().filter(ovomorph -> this.xenomorph.getTarget() != null || !ovomorph.canBeHeld()).forEach(Entity::stopRiding);
        if (this.xenomorph.getTarget() != null || this.targetOvomorph != null && !this.targetOvomorph.canBeHeld()) {
            this.setTargetOvomorph(null);
        }
    }

    private List<Ovomorph> getPassengerOvomorphs() {
        return this.xenomorph.getPassengers().stream().filter(passenger -> passenger.getType().is(AVPEntityTypeTags.OVOMORPHS)).map(entity -> (Ovomorph)entity).toList();
    }

    @Nullable
    public Ovomorph getTargetOvomorphOrNull() {
        return this.targetOvomorph;
    }

    public void setTargetOvomorph(Ovomorph targetOvomorph) {
        if (targetOvomorph == null) {
            if (this.targetOvomorph != null) {
                this.targetOvomorph.pickupRequestAcknowledged = false;
            }
        } else {
            targetOvomorph.pickupRequestAcknowledged = true;
        }
        this.targetOvomorph = targetOvomorph;
    }

    private void acknowledgePickupRequest(Ovomorph ovomorph) {
        if (this.targetOvomorph != null || !this.getPassengerOvomorphs().isEmpty() || this.xenomorph.getNavigation().createPath((Entity)ovomorph, 0) == null) {
            return;
        }
        ovomorph.pickupRequestAcknowledged = true;
        this.setTargetOvomorph(ovomorph);
    }
}

