/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.queen;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.ovipositor.Ovipositor;
import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.Queen;
import com.alien.common.registry.init.AlienEntityTypes;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.EntityUtil;
import com.just.core.functional.option.Option;
import com.lib.common.data.Cooldown;
import com.lib.common.gameplay.NBTSerializable;
import java.time.Duration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class OvipositorManager
implements NBTSerializable {
    private final Cooldown ovipositorCreationCooldown = Cooldown.withCooldownTime("ovipositorCreationCooldownInTicks", Duration.ofMinutes(1L));
    private final Queen queen;
    private boolean hadOvipositorLastTick;

    public OvipositorManager(Queen queen) {
        this.queen = queen;
    }

    public void tick() {
        if (this.queen.level().isClientSide) {
            return;
        }
        this.ovipositorCreationCooldown.tick();
        boolean hasOvipositor = this.hasOvipositor();
        if (!hasOvipositor && this.hadOvipositorLastTick) {
            this.ovipositorCreationCooldown.reset();
        }
        this.hadOvipositorLastTick = hasOvipositor;
        if (hasOvipositor) {
            this.getOvipositor().ifSome(ovipositor -> {
                ovipositor.setYRot(this.queen.getYRot());
                ovipositor.setXRot(this.queen.getXRot());
                ovipositor.yBodyRot = this.queen.yBodyRot;
                ovipositor.yHeadRot = this.queen.yHeadRot;
            });
            return;
        }
        if (!this.canCreateOvipositor()) {
            return;
        }
        this.createOvipositor();
        this.ovipositorCreationCooldown.reset();
    }

    public Vec3 getEggLayingPosition() {
        return EntityUtil.getRelativePosition((LivingEntity)this.queen, 6.0, 0.0, 2.5);
    }

    @Nullable
    public Ovipositor getOvipositorOrNull() {
        return this.queen.getPassengers().stream().filter(passenger -> passenger.getType() == AlienEntityTypes.OVIPOSITOR.get()).findFirst().orElse(null);
    }

    public Option<Ovipositor> getOvipositor() {
        return Option.ofNullable((Object)((Object)this.getOvipositorOrNull()));
    }

    public boolean hasOvipositor() {
        return this.getOvipositorOrNull() != null;
    }

    private void createOvipositor() {
        Ovipositor ovipositor = (Ovipositor)AlienEntityTypes.OVIPOSITOR.get().create(this.queen.level());
        if (ovipositor != null) {
            ovipositor.moveTo(this.queen.position(), this.queen.getYRot(), this.queen.getXRot());
            ovipositor.startRiding((Entity)this.queen, true);
            ovipositor.yBodyRot = this.queen.yBodyRot;
            ovipositor.yHeadRot = this.queen.yHeadRot;
            this.queen.level().addFreshEntity((Entity)ovipositor);
        }
    }

    private boolean canCreateOvipositor() {
        return this.queen.getTarget() == null && AlienVariantTypes.getFor(this.queen.getVariant()).canReproduce() && !this.queen.isPoisoned() && !this.ovipositorCreationCooldown.isActive() && this.queen.getHiveManager().hive().isSomeAnd(hive -> hive.isAlive() && !hive.isAngry() && hive.getMembershipManager().getMembersMatching(entityType -> entityType.is(AVPEntityTypeTags.XENOMORPHS)).size() > 2) && this.canOvipositorFit();
    }

    private boolean canOvipositorFit() {
        Vec3 leftBottomSupport = EntityUtil.getRelativePosition((LivingEntity)this.queen, 1.5, 0.0, 2.5);
        Vec3 rightBottomSupport = EntityUtil.getRelativePosition((LivingEntity)this.queen, -2.0, 0.0, 2.0);
        Vec3 farLeftBottomSupport = EntityUtil.getRelativePosition((LivingEntity)this.queen, 5.7, 0.0, 8.25);
        Vec3 backBottomSupport = EntityUtil.getRelativePosition((LivingEntity)this.queen, 0.0, 0.0, 7.0);
        return this.canOvipositorSupportExistAt(leftBottomSupport) && this.canOvipositorSupportExistAt(rightBottomSupport) && this.canOvipositorSupportExistAt(farLeftBottomSupport) && this.canOvipositorSupportExistAt(backBottomSupport) && this.isEggLayingPositionValid();
    }

    private boolean isEggLayingPositionValid() {
        Vec3 eggLayingPosition = this.getEggLayingPosition();
        BlockState blockState = this.queen.level().getBlockState(BlockPos.containing((Position)eggLayingPosition));
        boolean isClearForEgg = blockState.isAir() || blockState.canBeReplaced();
        return isClearForEgg && EntityUtil.canMobSeeBlock((Mob)this.queen, eggLayingPosition);
    }

    private boolean canOvipositorSupportExistAt(Vec3 vec3) {
        BlockPos blockPos = BlockPos.containing((Position)vec3);
        boolean isSupported = false;
        for (int stepsDown = 0; !isSupported && stepsDown < 4; ++stepsDown) {
            blockPos = blockPos.below();
            BlockState blockState = this.queen.level().getBlockState(blockPos);
            BlockState aboveBlockState = this.queen.level().getBlockState(blockPos.above());
            isSupported = (aboveBlockState.isAir() || aboveBlockState.canBeReplaced()) && !blockState.isAir() && !blockState.canBeReplaced();
        }
        return isSupported && EntityUtil.canMobSeeBlock((Mob)this.queen, vec3);
    }

    @Override
    public void load(CompoundTag compoundTag) {
        this.ovipositorCreationCooldown.load(compoundTag);
    }

    @Override
    public void save(CompoundTag compoundTag) {
        this.ovipositorCreationCooldown.save(compoundTag);
    }
}

