/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.runner;

import com.alien.common.gameplay.ai.CreateVentGoal;
import com.alien.common.gameplay.ai.DropOffEggGoal;
import com.alien.common.gameplay.ai.PickUpEggGoal;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.EggCarrier;
import com.alien.common.gameplay.entity.living.alien.xenomorph.EggPickupManager;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.runner.RunnerAnimationDispatcher;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.resin.ResinData;
import com.alien.common.registry.init.AlienEntityTypes;
import com.avp.AVP;
import com.avp.common.gameplay.ai.goal.combat.LungeAtTargetGoal;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.EntityUtil;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Runner
extends Xenomorph
implements EggCarrier {
    private final RunnerAnimationDispatcher animationDispatcher = new RunnerAnimationDispatcher(this);
    private final EggPickupManager eggPickupManager;

    public static AttributeSupplier.Builder createRunnerAttributes() {
        return Runner.applyFrom(AVP.config.statsConfigs.RUNNER_STATS, Monster.createMonsterAttributes());
    }

    public Runner(EntityType<? extends Runner> entityType, Level level) {
        super((EntityType<? extends Xenomorph>)entityType, level);
        this.config = AVP.config.statsConfigs.RUNNER_STATS;
        this.eggPickupManager = new EggPickupManager(this);
    }

    @Override
    @Nullable
    public EntityType<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Runner.getType(alienVariant);
    }

    @Override
    @Nullable
    protected ResinData createResinData() {
        return new ResinData(0, 16, 1, AVP.config.statsConfigs.RUNNER_STATS.nestTickrate);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new LungeAtTargetGoal((Mob)this, 0.05f, 140, 6.0, 12.0).setOnLungeCallback(this::runLungeAnimation));
        this.goalSelector.addGoal(4, new PickUpEggGoal<Runner>(this));
        this.goalSelector.addGoal(5, new DropOffEggGoal<Runner>(this));
        this.goalSelector.addGoal(6, (Goal)new CreateVentGoal(this));
    }

    @Override
    public void tick() {
        super.tick();
        this.eggPickupManager.tick();
    }

    @Override
    protected boolean canEntityRideAlien(@NotNull Entity passenger) {
        return super.canEntityRideAlien(passenger) || passenger.getType().is(AVPEntityTypeTags.OVOMORPHS);
    }

    protected void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (passenger.getType().is(AVPEntityTypeTags.OVOMORPHS)) {
            Vec3 relativePos = EntityUtil.getRelativePosition((LivingEntity)this, 0.0, 0.8, -1.0);
            callback.accept(passenger, relativePos.x, relativePos.y, relativePos.z);
            return;
        }
        super.positionRider(passenger, callback);
    }

    @Override
    public void runAttackAnimations() {
        int attackType = this.random.nextInt(0, 3);
        this.playSound(AVPSoundEvents.ENTITY_XENOMORPH_ATTACK.get(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        switch (attackType) {
            case 0: {
                this.animationDispatcher.rightClawAttack();
                break;
            }
            case 1: {
                this.animationDispatcher.biteAttack();
                break;
            }
            default: {
                this.animationDispatcher.tailAttackQuad();
            }
        }
    }

    private void runLungeAnimation() {
        this.playSound(AVPSoundEvents.ENTITY_XENOMORPH_LUNGE.get(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        this.animationDispatcher.lunge();
    }

    @Override
    public void updateDynamicGameEventListener(@NotNull BiConsumer<DynamicGameEventListener<?>, ServerLevel> biConsumer) {
        super.updateDynamicGameEventListener(biConsumer);
        this.eggPickupManager.updateDynamicGameEventListener(biConsumer);
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.RUNNER_STATS.healthRegenPerSecond;
    }

    @Override
    public Integer getMaxJellyToGrowth() {
        return 2;
    }

    @Override
    protected double getPursuitSpeedModifier() {
        return 1.2;
    }

    public RunnerAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    public static EntityType<? extends Alien> getType(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.RUNNER.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_RUNNER.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_RUNNER.get();
            case AlienVariant.IRRADIATED -> AlienEntityTypes.IRRADIATED_RUNNER.get();
        };
    }

    @Override
    public EggPickupManager getEggPickupManager() {
        return this.eggPickupManager;
    }
}

