/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.xenomorph.crusher.Crusher;
import com.alien.common.gameplay.entity.living.alien.xenomorph.drone.Drone;
import com.alien.common.gameplay.entity.living.alien.xenomorph.praetorian.Praetorian;
import com.alien.common.gameplay.entity.living.alien.xenomorph.prowler.Prowler;
import com.alien.common.gameplay.entity.living.alien.xenomorph.runner.Runner;
import com.alien.common.gameplay.entity.living.alien.xenomorph.warrior.Warrior;
import com.alien.common.gameplay.hive.HiveBossBarManager;
import com.alien.common.gameplay.hive.HiveDebugManager;
import com.alien.common.gameplay.hive.HiveRemovalReason;
import com.alien.common.gameplay.hive.HiveSpaceManager;
import com.alien.common.gameplay.hive.ai.task.Task;
import com.alien.common.gameplay.hive.ai.task.impl.MergeWithNearbyHiveTask;
import com.alien.common.gameplay.hive.ai.task.impl.PickBestLeaderTask;
import com.alien.common.gameplay.hive.ai.task.impl.balance.BalanceAveragingHiveTask;
import com.alien.common.gameplay.hive.ai.task.impl.balance.BalanceQueenHiveTask;
import com.alien.common.gameplay.hive.ai.task.impl.balance.BalanceStepHiveTask;
import com.alien.common.gameplay.hive.membership.HiveLeadershipManager;
import com.alien.common.gameplay.hive.membership.HiveMembershipManager;
import com.alien.common.gameplay.hive.membership.HiveReserveManager;
import com.alien.common.gameplay.hive.vent.HiveVentManager;
import com.alien.common.gameplay.level.saveddata.QueenSpawnChunkData;
import com.alien.common.model.alien.variant.AlienVariant;
import com.avp.AVP;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.lib.common.gameplay.NBTSerializable;
import com.lib.common.gameplay.util.spatial.chunk.ChunkPosUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Hive
implements NBTSerializable {
    private static final AlienVariant DEFAULT_VARIANT = AlienVariant.NORMAL;
    private static final String AGE_IN_TICKS_KEY = "AgeInTicks";
    private static final String CENTER_POS_KEY = "CenterPos";
    private static final String VARIANT_ID_KEY = "VariantId";
    private final HiveBossBarManager bossBarManager;
    private final HiveDebugManager debugManager;
    private final HiveLeadershipManager leadershipManager;
    private final HiveMembershipManager membershipManager;
    private final HiveReserveManager reserveManager;
    private final HiveSpaceManager spaceManager;
    private final HiveVentManager ventManager;
    private final UUID id;
    private final Level level;
    private final RandomSource randomSource;
    private final List<Task> tasks;
    @Nullable
    private HiveRemovalReason removalReason;
    private BlockPos centerPos;
    private int ageInTicks;
    private AlienVariant variant = DEFAULT_VARIANT;

    public Hive(Level level, UUID id) {
        this.tasks = new ArrayList<Task>();
        this.id = id;
        this.removalReason = null;
        this.level = level;
        this.bossBarManager = new HiveBossBarManager(this);
        this.debugManager = new HiveDebugManager(this);
        this.leadershipManager = new HiveLeadershipManager(this);
        this.membershipManager = new HiveMembershipManager(this);
        this.randomSource = level.random.fork();
        this.reserveManager = new HiveReserveManager(this);
        this.spaceManager = new HiveSpaceManager(this);
        this.ventManager = new HiveVentManager();
        this.centerPos = BlockPos.ZERO;
        this.tasks.add(new BalanceAveragingHiveTask(this, () -> Runner.getType(this.getVariant()), () -> Prowler.getType(this.getVariant())));
        this.tasks.add(new BalanceStepHiveTask(this, () -> Prowler.getType(this.getVariant()), () -> Crusher.getType(this.getVariant())));
        this.tasks.add(new BalanceAveragingHiveTask(this, () -> Drone.getType(this.getVariant()), () -> Warrior.getType(this.getVariant())));
        this.tasks.add(new BalanceStepHiveTask(this, () -> Warrior.getType(this.getVariant()), () -> Praetorian.getType(this.getVariant())));
        this.tasks.add(new BalanceQueenHiveTask(this));
        this.tasks.add(new PickBestLeaderTask(this));
        this.tasks.add(new MergeWithNearbyHiveTask(this));
    }

    public void tick() {
        if (!this.isActive()) {
            return;
        }
        this.bossBarManager.tick();
        this.debugManager.tick();
        this.leadershipManager.tick();
        this.membershipManager.tick();
        this.reserveManager.tick();
        this.tasks.stream().filter(Task::canRun).forEach(Task::run);
        if (this.ageInTicks % 20 == 0 && !this.hasXenomorphs()) {
            this.remove(HiveRemovalReason.KILLED);
        }
        ++this.ageInTicks;
    }

    public void moveCenter(BlockPos newCenterPos) {
        this.centerPos = newCenterPos;
    }

    public boolean requestToJoin(Entity requestingEntity) {
        Alien alien;
        if (!(requestingEntity instanceof Alien) || !Objects.equals((Object)(alien = (Alien)requestingEntity).getVariant(), (Object)this.variant)) {
            return false;
        }
        if (!this.spaceManager.isEntityLeashedToHive(requestingEntity)) {
            return false;
        }
        this.membershipManager.addMember(requestingEntity);
        return true;
    }

    public void ping(@NotNull Entity entity) {
        if (!entity.isAlive() || this.membershipManager.isMember(entity) && !this.spaceManager.isEntityLeashedToHive(entity)) {
            this.removeHiveMember(entity);
            return;
        }
        this.membershipManager.addMember(entity);
    }

    public void removeHiveMember(@NotNull Entity entity) {
        this.leadershipManager.removeLeadership(entity);
        this.membershipManager.removeMember(entity);
    }

    public boolean isActive() {
        return this.bossBarManager.isTrackingPlayers() || this.isChunkLoaded();
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public boolean hasXenomorphs() {
        return !this.membershipManager.getMembersMatching(entityType -> entityType.is(AVPEntityTypeTags.XENOMORPHS)).isEmpty();
    }

    @Nullable
    public HiveRemovalReason getRemovalReason() {
        return this.removalReason;
    }

    public boolean isRemoved() {
        return this.removalReason != null;
    }

    public void remove(HiveRemovalReason removalReason) {
        this.removalReason = removalReason;
    }

    public void onRemove() {
        this.bossBarManager.onHiveRemoved();
        this.debugManager.onHiveRemoved();
        if (this.level.getDifficulty() != Difficulty.PEACEFUL) {
            QueenSpawnChunkData.getOrCreate(this.level).ifSome(queenSpawnChunkData -> {
                int chunkRadiusToBlacklist = AVP.config.hiveConfigs.MINIMUM_DISTANCE_BETWEEN_NATURAL_QUEEN_SPAWNS_IN_CHUNKS;
                Set<ChunkPos> nearbyChunkPositions = ChunkPosUtil.getChunksAround(this.centerPosition(), chunkRadiusToBlacklist);
                nearbyChunkPositions.forEach(queenSpawnChunkData::addChunkToBlacklist);
            });
        }
    }

    public boolean isAngry() {
        return this.bossBarManager.isTrackingPlayers();
    }

    private boolean isChunkLoaded() {
        return this.level.getChunkSource().getChunkNow(this.centerPos.getX() >> 4, this.centerPos.getZ() >> 4) != null;
    }

    @Override
    public void load(CompoundTag compoundTag) {
        this.leadershipManager.load(compoundTag);
        this.membershipManager.load(compoundTag);
        this.reserveManager.load(compoundTag);
        int[] centerPosComponents = compoundTag.getIntArray(CENTER_POS_KEY);
        this.ageInTicks = compoundTag.getInt(AGE_IN_TICKS_KEY);
        this.centerPos = new BlockPos(centerPosComponents[0], centerPosComponents[1], centerPosComponents[2]);
        if (compoundTag.contains(VARIANT_ID_KEY)) {
            this.variant = (AlienVariant)((Object)AlienVariant.getById(compoundTag.getByte(VARIANT_ID_KEY)).unwrapOr((Object)DEFAULT_VARIANT));
        }
    }

    @Override
    public void save(CompoundTag compoundTag) {
        this.leadershipManager.save(compoundTag);
        this.membershipManager.save(compoundTag);
        this.reserveManager.save(compoundTag);
        compoundTag.putInt(AGE_IN_TICKS_KEY, this.ageInTicks);
        int[] centerPosComponents = new int[]{this.centerPos.getX(), this.centerPos.getY(), this.centerPos.getZ()};
        compoundTag.putIntArray(CENTER_POS_KEY, centerPosComponents);
        compoundTag.putByte(VARIANT_ID_KEY, (byte)this.variant.getId());
    }

    public int ageInTicks() {
        return this.ageInTicks;
    }

    public BlockPos centerPosition() {
        return this.centerPos;
    }

    public HiveBossBarManager getBossBarManager() {
        return this.bossBarManager;
    }

    public HiveDebugManager getDebugManager() {
        return this.debugManager;
    }

    public UUID id() {
        return this.id;
    }

    public HiveLeadershipManager getLeadershipManager() {
        return this.leadershipManager;
    }

    public HiveMembershipManager getMembershipManager() {
        return this.membershipManager;
    }

    public RandomSource getRandom() {
        return this.randomSource;
    }

    public HiveReserveManager getReserveManager() {
        return this.reserveManager;
    }

    public HiveSpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public HiveVentManager getVentManager() {
        return this.ventManager;
    }

    public AlienVariant getVariant() {
        return this.variant;
    }

    public void setVariant(AlienVariant variant) {
        this.variant = variant;
    }

    public Level level() {
        return this.level;
    }
}

